/*
 * @(#)CsOutPlannedDifferenceAdjustReqDto.java 1.0 2022年05月13日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutPlannedDifferenceAdjustReqDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 **/
@ApiModel(value = "CsOutPlannedDifferenceAdjustReqDto", description = "超发差异数据调整DTO")
public class CsOutPlannedDifferenceAdjustReqDto implements Serializable {

    /**
     * 出库结果单单号
     **/
    @ApiModelProperty(name = "outResultDocumentNo", value = "出库结果单单号")
    private String outResultDocumentNo;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsOutPlannedDifferenceAdjustDetailReqDto> detailReqDtoList;

    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public CsOutPlannedDifferenceAdjustReqDto() {
    }

    public String getOutResultDocumentNo() {
        return outResultDocumentNo;
    }

    public void setOutResultDocumentNo(String outResultDocumentNo) {
        this.outResultDocumentNo = outResultDocumentNo;
    }

    public List<CsOutPlannedDifferenceAdjustDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsOutPlannedDifferenceAdjustDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}