/**
 * @(#)CsInPlannedOrderQueryDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author jingran
 * @Description CsOutPlannedOrderPageQueryDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 */
@ApiModel(value = "CsOutPlannedOrderPageQueryDto", description = "查询Dto")
public class CsOutPlannedOrderPageQueryDto extends RequestDto {
    /**
     * 单据号,系统生成的计划类单据号
     **/
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     */
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
     * 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起")
    private String orderStatus;
    /**
     * 发货仓库编码
     **/
    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货仓库编码")
    private String deliveryWarehouseCode;
    /**
     * 发货仓库名称
     **/
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货仓库名称")
    private String deliveryWarehouseName;
    /**
     * 创建时间 查询时间段
     */
    @ApiModelProperty(name = "createTimeStart", value = "创建时间")
    private String createTimeStart;
    /**
     * 创建时间 查询时间段
     */
    @ApiModelProperty(name = "createTimeEnd", value = "创建时间")
    private String createTimeEnd;
    /**
     * 页码
     **/
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    /**
     * 分页大小
     **/
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    /**
     * 降序排序
     **/
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }
}