/**
 * @(#)CsOutPlannedOrderQueryDto.java 1.0 2022/04/13 16:40
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsOutPlannedOrderQueryDto
*
* @author jingran
* @Date: 2022/04/13 16:40
* @since 1.0.0
*/
@ApiModel(value = "csOutPlannedOrderQueryDto", description = "查询Dto")
public class CsOutPlannedOrderQueryDto extends RequestDto {

    /** 平台单号(来源于第三方系统) */
    @ApiModelProperty(name="platformOrderNo",value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /** 单据号,系统生成的计划类单据号 */
    @ApiModelProperty(name="orderNo",value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /** 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="orderType",value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /** 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="businessType",value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /** 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起 */
    @ApiModelProperty(name="orderStatus",value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起")
    private String orderStatus;
    /** 发货仓库ID */
    @ApiModelProperty(name="deliveryWarehouseId",value = "发货仓库ID")
    private Long deliveryWarehouseId;
    /** 发货仓库编码 */
    @ApiModelProperty(name="deliveryWarehouseCode",value = "发货仓库编码")
    private String deliveryWarehouseCode;
    /** 发货仓库名称 */
    @ApiModelProperty(name="deliveryWarehouseName",value = "发货仓库名称")
    private String deliveryWarehouseName;
    /** 供应商ID */
    @ApiModelProperty(name="supplierId",value = "供应商ID")
    private Long supplierId;
    /** 供应商编码 */
    @ApiModelProperty(name="supplierCode",value = "供应商编码")
    private String supplierCode;
    /** 供应商名称 */
    @ApiModelProperty(name="supplierName",value = "供应商名称")
    private String supplierName;
    /** 总数量 */
    @ApiModelProperty(name="totalQuantity",value = "总数量")
    private BigDecimal totalQuantity;
    /** 已出总数量 */
    @ApiModelProperty(name="doneOutQuantity",value = "已出总数量")
    private BigDecimal doneOutQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getDeliveryWarehouseId() {
        return deliveryWarehouseId;
    }

    public void setDeliveryWarehouseId(Long deliveryWarehouseId) {
        this.deliveryWarehouseId = deliveryWarehouseId;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getDoneOutQuantity() {
        return doneOutQuantity;
    }

    public void setDoneOutQuantity(BigDecimal doneOutQuantity) {
        this.doneOutQuantity = doneOutQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}