package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out;

import com.dtyunxi.yundt.cube.center.inventory.enums.YesNoEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsWmsOutSendBackReqDto", description = "wms出库回传DTO")
public class CsWmsOutSendBackReqDto implements Serializable {

    /**
     * wms订单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms订单号")
    private String wmsOrderNo;

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 出库通知单号
     **/
    @ApiModelProperty(name = "outNoticeOrderNo", value = "出库通知单号")
    private String outNoticeOrderNo;

    /**
     * 出库时间
     **/
    @ApiModelProperty(name = "outTime", value = "出库时间")
    private Date outTime;

    /**
     * 预计到货时间
     **/
    @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
    private Date estimatedTime;

    /**
     * 总箱数
     **/
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;

    /**
     * 拼箱数
     **/
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;

    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "detailReqDtoList", value = "商品明细信息")
    private List<CsWmsOutSendBackDetailReqDto> detailReqDtoList;

    /**
     * 物流信息
     **/
    @ApiModelProperty(name = "shippingInfoReqDtoList", value = "物流信息")
    private List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList;

    @ApiModelProperty(name = "isAllDeal", value = "是否整单处理:1.是，0.否(整单处理表示只接收一次回传结果)")
    private Integer isAllDeal = YesNoEnum.YES.getValue();

    @ApiModelProperty(name = "allowBatchChange", value = "允许批次变更：true.允许，false.不允许 （默认允许）")
    private Boolean allowBatchChange = true;

    @ApiModelProperty(name = "enableAdjustInTransit", value = "是否需要调整在途(满足前提情况下)")
    private Boolean enableAdjustInTransit  = false;

    /**
     * 外部驱动结果单挂起标识
     */
    @ApiModelProperty(name = "isHangUp", value = "是否需要挂起，默认不需要")
    private Boolean isHangUp = false;

    @ApiModelProperty(name = "extensionExternal", value = "外部扩展信息")
    private String extensionExternal;

    @ApiModelProperty(name = "bizType", value = "业务类型")
    private String bizType;

    public String getExtensionExternal() {
        return extensionExternal;
    }

    public void setExtensionExternal(String extensionExternal) {
        this.extensionExternal = extensionExternal;
    }

    public Boolean getHangUp() {
        return isHangUp;
    }

    public void setHangUp(Boolean hangUp) {
        isHangUp = hangUp;
    }

    public Integer getIsAllDeal() {
        return isAllDeal;
    }

    public void setIsAllDeal(Integer isAllDeal) {
        this.isAllDeal = isAllDeal;
    }



    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public List<CsWmsOutSendBackDetailReqDto> getDetailReqDtoList() {
        return detailReqDtoList;
    }

    public void setDetailReqDtoList(List<CsWmsOutSendBackDetailReqDto> detailReqDtoList) {
        this.detailReqDtoList = detailReqDtoList;
    }

    public String getOutNoticeOrderNo() {
        return outNoticeOrderNo;
    }

    public void setOutNoticeOrderNo(String outNoticeOrderNo) {
        this.outNoticeOrderNo = outNoticeOrderNo;
    }

    public Date getOutTime() {
        return outTime;
    }

    public void setOutTime(Date outTime) {
        this.outTime = outTime;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public Date getEstimatedTime() {
        return estimatedTime;
    }

    public void setEstimatedTime(Date estimatedTime) {
        this.estimatedTime = estimatedTime;
    }

    public List<CsWmsShippingInfoReqDto> getShippingInfoReqDtoList() {
        return shippingInfoReqDtoList;
    }

    public void setShippingInfoReqDtoList(List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList) {
        this.shippingInfoReqDtoList = shippingInfoReqDtoList;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public Boolean getAllowBatchChange() {
        return allowBatchChange;
    }

    public void setAllowBatchChange(Boolean allowBatchChange) {
        this.allowBatchChange = allowBatchChange;
    }

    public Boolean getEnableAdjustInTransit() {
        return enableAdjustInTransit;
    }

    public void setEnableAdjustInTransit(Boolean enableAdjustInTransit) {
        this.enableAdjustInTransit = enableAdjustInTransit;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }
}
