package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/4/19 3:55 下午
 */
@ApiModel(value = "CsWmsShippingInfoReqDto", description = "wms出库回传物流信息DTO")
public class CsWmsShippingInfoReqDto implements Serializable {

    /**
     * wms订单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms订单号")
    private String wmsOrderNo;

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    /**
     * 出库通知单号
     **/
    @ApiModelProperty(name = "outNoticeOrderNo", value = "出库通知单号")
    private String outNoticeOrderNo;

    /**
     * 物流公司编码
     **/
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;

    /**
     * 物流公司名称
     **/
    @ApiModelProperty(name = "shippingCompanyName", value = "物流公司名称")
    private String shippingCompanyName;
    /**
     * 物流单号
     **/
    @ApiModelProperty(name = "shippingNo", value = "物流单号")
    private String shippingNo;

    @ApiModelProperty(name = "shippingType", value = "运输方式")
    private String shippingType;

    /**
     *  承运方式(多个使用逗号分隔),0-海运,1-整车,2-整担
     **/
    @ApiModelProperty(name = "logisticsType", value = " 承运方式(多个使用逗号分隔),0-海运,1-整车,2-整担")
    private String logisticsType;

    /**
     * 托运单号
     **/
    @ApiModelProperty(name = "consignNo", value = "托运单号")
    private String consignNo;

    /**
     * 发货时间
     **/
    @ApiModelProperty(name = "deliveryTime", value = "发货时间")
    private Date deliveryTime;

    /**
     * 预计到货时间
     */
    @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
    private Date estimatedTime;

    public CsWmsShippingInfoReqDto() {
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompanyName() {
        return shippingCompanyName;
    }

    public void setShippingCompanyName(String shippingCompanyName) {
        this.shippingCompanyName = shippingCompanyName;
    }

    public String getShippingNo() {
        return shippingNo;
    }

    public void setShippingNo(String shippingNo) {
        this.shippingNo = shippingNo;
    }

    public String getOutNoticeOrderNo() {
        return outNoticeOrderNo;
    }

    public void setOutNoticeOrderNo(String outNoticeOrderNo) {
        this.outNoticeOrderNo = outNoticeOrderNo;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public String getLogisticsType() {
        return logisticsType;
    }

    public void setLogisticsType(String logisticsType) {
        this.logisticsType = logisticsType;
    }

    public String getConsignNo() {
        return consignNo;
    }

    public void setConsignNo(String consignNo) {
        this.consignNo = consignNo;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getEstimatedTime() {
        return estimatedTime;
    }

    public void setEstimatedTime(Date estimatedTime) {
        this.estimatedTime = estimatedTime;
    }
}
