package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.tob;

import com.dtyunxi.yundt.cube.center.data.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(
        value = "ReturnItemConfirmDetailReqDto",
        description = "售后商品入库明细"
)
public class ReturnItemConfirmDetailReqDto extends BaseReqDto {
    @ApiModelProperty(
            name = "itemId",
            value = "商品id"
    )
    private String itemId;
    @ApiModelProperty(
            name = "itemCode",
            value = "商品编码"
    )
    private String itemCode;
    @ApiModelProperty(
            name = "itemName",
            value = "商品名称"
    )
    private String itemName;
    @ApiModelProperty(
            name = "cargoSerial",
            value = "货品id"
    )
    private String cargoSerial;
    @ApiModelProperty(
            name = "cargoCode",
            value = "货品编码"
    )
    private String cargoCode;
    @ApiModelProperty(
            name = "buyNum",
            value = "订购数量"
    )
    private Long buyNum;
    @ApiModelProperty(
            name = "currentNum",
            value = "本次入库数量"
    )
    private Long currentNum;
    @ApiModelProperty(
            name = "receivedNum",
            value = "已入库数量"
    )
    private Long receivedNum;
    @ApiModelProperty(
            name = "skuSerial",
            value = "skuID"
    )
    private String skuSerial;
    @ApiModelProperty(
            name = "gift",
            value = "赠品：1是，0否, 默认0"
    )
    private Integer gift = 0;
    @ApiModelProperty(
            name = "batchNo",
            value = "批次号"
    )
    private String batchNo;
    @ApiModelProperty(
            name = "itemPrice",
            value = "商品实付价格"
    )
    private BigDecimal itemPrice;
    @ApiModelProperty(
            name = "itemOrigPrice",
            value = "商品应付单价"
    )
    private BigDecimal itemOrigPrice;
    @ApiModelProperty(
            name = "orderNo",
            value = "原订单号"
    )
    private String orderNo;
    @ApiModelProperty(
            name = "ifExchange",
            value = "是否为换购商品，0否，1是"
    )
    private Integer ifExchange;
    @ApiModelProperty(
            name = "tradeOrderItemId",
            value = "原订单商品行ID"
    )
    private Long tradeOrderItemId;
    @ApiModelProperty(
            name = "matchNum",
            value = "已匹配数量"
    )
    private Long matchedNum = 0L;
    public ReturnItemConfirmDetailReqDto() {
    }

    public Long getMatchedNum() {
        return this.matchedNum;
    }

    public void setMatchedNum(Long matchedNum) {
        this.matchedNum = matchedNum;
    }

    public Long getTradeOrderItemId() {
        return this.tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }

    public Integer getIfExchange() {
        return this.ifExchange;
    }

    public void setIfExchange(Integer ifExchange) {
        this.ifExchange = ifExchange;
    }

    public String getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getCargoCode() {
        return this.cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Integer getGift() {
        return this.gift;
    }

    public void setGift(Integer gift) {
        this.gift = gift;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }
    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getBuyNum() {
        return this.buyNum;
    }

    public void setBuyNum(Long buyNum) {
        this.buyNum = buyNum;
    }

    public Long getCurrentNum() {
        return this.currentNum;
    }

    public void setCurrentNum(Long currentNum) {
        this.currentNum = currentNum;
    }

    public Long getReceivedNum() {
        return this.receivedNum;
    }

    public void setReceivedNum(Long receivedNum) {
        this.receivedNum = receivedNum;
    }

    public String getCargoSerial() {
        return this.cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getSkuSerial() {
        return this.skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public BigDecimal getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public BigDecimal getItemOrigPrice() {
        return this.itemOrigPrice;
    }

    public void setItemOrigPrice(BigDecimal itemOrigPrice) {
        this.itemOrigPrice = itemOrigPrice;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}
