/**
 * @(#)CsInventoryWarningAddReqDto.java 1.0 2022/06/13 17:01
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @Description CsInventoryWarningAddReqDto
*
* @author jingran
* @Date: 2022/06/13 17:01
* @since 1.0.0
*/
@ApiModel(value = "csInventoryWarningAddReqDto", description = "新增Dto")
public class CsInventoryWarningAddReqDto implements Serializable {

    /** 商品sku编码 */
    @ApiModelProperty(name="skuCode",value = "商品sku编码")
    private String skuCode;
    /** 商品sku名称 */
    @ApiModelProperty(name="skuName",value = "商品sku名称")
    private String skuName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型")
    private String warehouseType;
    /** 预警库存 */
    @ApiModelProperty(name="warningInventory",value = "预警库存")
    private BigDecimal warningInventory;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getWarningInventory() {
        return warningInventory;
    }

    public void setWarningInventory(BigDecimal warningInventory) {
        this.warningInventory = warningInventory;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }
}