/**
 * @(#)CsPlannedOrderAuditAddReqDto.java 1.0 2022/04/13 15:43
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
* @Description CsPlannedOrderAuditAddReqDto
*
* @author jingran
* @Date: 2022/04/13 15:43
* @since 1.0.0
*/
@ApiModel(value = "csPlannedOrderAuditAddReqDto", description = "新增Dto")
public class CsPlannedOrderAuditAddReqDto implements Serializable {

    /** 平台单号(来源于第三方系统) */
    @ApiModelProperty(name="platformOrderNo",value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /** 单据号,系统生成的计划类单据号 */
    @ApiModelProperty(name="orderNo",value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /** 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="orderType",value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /** 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单 */
    @ApiModelProperty(name="businessType",value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /** 审核结果:audit_pass-审核通过,audit_failed-审核不通过 */
    @ApiModelProperty(name="auditResult",value = "审核结果:audit_pass-审核通过,audit_failed-审核不通过")
    private String auditResult;
    /** 审核备注信息 */
    @ApiModelProperty(name="remark",value = "审核备注信息")
    private String remark;
    /** 审核人用户ID */
    @ApiModelProperty(name="auditUserId",value = "审核人用户ID")
    private Long auditUserId;
    /** 审核人用户名称 */
    @ApiModelProperty(name="auditUserName",value = "审核人用户名称")
    private Long auditUserName;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getAuditResult() {
        return auditResult;
    }

    public void setAuditResult(String auditResult) {
        this.auditResult = auditResult;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getAuditUserId() {
        return auditUserId;
    }

    public void setAuditUserId(Long auditUserId) {
        this.auditUserId = auditUserId;
    }

    public Long getAuditUserName() {
        return auditUserName;
    }

    public void setAuditUserName(Long auditUserName) {
        this.auditUserName = auditUserName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

}