package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderDetailRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * @description:生产订单dto
 * @projectName:yundt-cube-center-inventory
 * @see:com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other
 * @author:初见
 * @createTime:2022/3/31 14:27
 */
@ApiModel(value = "csPurchaseOrderReqDto", description = "生产订单dto")
public class CsProduceOrderReqDto extends BaseRespDto {
    /** 生产订单单号 */
    @ApiModelProperty(name="documentNo",value = "生产订单单号")
    private String documentNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;
    /** 单据状态 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 供应商 */
    @ApiModelProperty(name="supplier",value = "供应商")
    private String supplier;
    /** 总数量 */
    @ApiModelProperty(name="totalQuantity",value = "总数量")
    private BigDecimal totalQuantity;
    /** 收货仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "收货仓库编码")
    private String warehouseCode;
    /** 收货仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "收货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /** 预估收货时间 */
    @ApiModelProperty(name="receivePredictTime",value = "预估收货时间")
    private String receivePredictTime;

    @ApiModelProperty(name = "deliveryNoticeOrderDetailRespDtoList", value = "发货货品详情")
    private List<CsDeliveryResultOrderDetailRespDto> deliveryResultOrderDetailRespDtoList;

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getReceivePredictTime() {
        return receivePredictTime;
    }

    public void setReceivePredictTime(String receivePredictTime) {
        this.receivePredictTime = receivePredictTime;
    }

    public List<CsDeliveryResultOrderDetailRespDto> getDeliveryResultOrderDetailRespDtoList() {
        return deliveryResultOrderDetailRespDtoList;
    }

    public void setDeliveryResultOrderDetailRespDtoList(List<CsDeliveryResultOrderDetailRespDto> deliveryResultOrderDetailRespDtoList) {
        this.deliveryResultOrderDetailRespDtoList = deliveryResultOrderDetailRespDtoList;
    }
}
