/**
 * @(#)csShipmenetEnterpriseQueryDto.java 1.0 2022/03/15 10:38
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* @Description csShipmenetEnterpriseQueryDto
*
* @author chujian
* @Date: 2022/03/15 10:38
* @since 1.0.0
*/
@ApiModel(value = "csShipmenetEnterpriseQueryDto", description = "查询Dto")
public class CsShipmenetEnterpriseQueryDto extends RequestDto {

    /** 物流商编码 */
    @ApiModelProperty(name="shipmentEnterpriseCode",value = "物流商编码")
    private String shipmentEnterpriseCode;
    /** 物流商名称 */
    @ApiModelProperty(name="shipmentEnterpriseName",value = "物流商名称")
    private String shipmentEnterpriseName;
    /** 物流商简称 */
    @ApiModelProperty(name="shipmentEnterpriseReduceName",value = "物流商简称")
    private String shipmentEnterpriseReduceName;
    /** 物流商类型 1-物流 2-快递 */
    @ApiModelProperty(name="shipmentEnterpriseType",value = "物流商类型 1-物流 2-快递")
    private Long shipmentEnterpriseType;
    /** 打印方式  1-唯品打印 2-拼多多 3-菜鸟打印 4-普通打印 */
    @ApiModelProperty(name="printType",value = "打印方式  1-唯品打印 2-拼多多 3-菜鸟打印 4-普通打印")
    private Long printType;
    /** 辅助编码 */
    @ApiModelProperty(name="assistCode",value = "辅助编码")
    private String assistCode;
    /** 体积系数 */
    @ApiModelProperty(name="volumeRatio",value = "体积系数")
    private BigDecimal volumeRatio;
    /** 联系人 */
    @ApiModelProperty(name="contact",value = "联系人")
    private String contact;
    /** 联系方式 */
    @ApiModelProperty(name="contactPhone",value = "联系方式")
    private String contactPhone;
    /** 邮箱 */
    @ApiModelProperty(name="email",value = "邮箱")
    private String email;
    /** 状态  1-有效 0-无效 */
    @ApiModelProperty(name="shipmentEnterpriseStatus",value = "状态  1-有效 0-无效")
    private Long shipmentEnterpriseStatus;
    /** 联系地址 */
    @ApiModelProperty(name="contactAddress",value = "联系地址")
    private String contactAddress;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public String getShipmentEnterpriseCode() {
        return shipmentEnterpriseCode;
    }

    public void setShipmentEnterpriseCode(String shipmentEnterpriseCode) {
        this.shipmentEnterpriseCode = shipmentEnterpriseCode;
    }

    public String getShipmentEnterpriseName() {
        return shipmentEnterpriseName;
    }

    public void setShipmentEnterpriseName(String shipmentEnterpriseName) {
        this.shipmentEnterpriseName = shipmentEnterpriseName;
    }

    public String getShipmentEnterpriseReduceName() {
        return shipmentEnterpriseReduceName;
    }

    public void setShipmentEnterpriseReduceName(String shipmentEnterpriseReduceName) {
        this.shipmentEnterpriseReduceName = shipmentEnterpriseReduceName;
    }

    public Long getShipmentEnterpriseType() {
        return shipmentEnterpriseType;
    }

    public void setShipmentEnterpriseType(Long shipmentEnterpriseType) {
        this.shipmentEnterpriseType = shipmentEnterpriseType;
    }

    public Long getPrintType() {
        return printType;
    }

    public void setPrintType(Long printType) {
        this.printType = printType;
    }

    public String getAssistCode() {
        return assistCode;
    }

    public void setAssistCode(String assistCode) {
        this.assistCode = assistCode;
    }

    public BigDecimal getVolumeRatio() {
        return volumeRatio;
    }

    public void setVolumeRatio(BigDecimal volumeRatio) {
        this.volumeRatio = volumeRatio;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getShipmentEnterpriseStatus() {
        return shipmentEnterpriseStatus;
    }

    public void setShipmentEnterpriseStatus(Long shipmentEnterpriseStatus) {
        this.shipmentEnterpriseStatus = shipmentEnterpriseStatus;
    }

    public String getContactAddress() {
        return contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}