/**
 * @(#)csShipmenetEnterpriseUpdateReqDto.java 1.0 2022/03/15 10:38
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* @Description csShipmenetEnterpriseUpdateReqDto
*
* @author chujian
* @Date: 2022/03/15 10:38
* @since 1.0.0
*/
@ApiModel(value = "csShipmenetEnterpriseUpdateReqDto", description = "修改Dto")
public class CsShipmenetEnterpriseUpdateReqDto extends RequestDto {

    /** 物流商编码 */
    @ApiModelProperty(name="shipmentEnterpriseCode",value = "物流商编码")
    private String shipmentEnterpriseCode;
    /** 物流商名称 */
    @ApiModelProperty(name="shipmentEnterpriseName",value = "物流商名称")
    private String shipmentEnterpriseName;
    /** 物流商简称 */
    @ApiModelProperty(name="shipmentEnterpriseReduceName",value = "物流商简称")
    private String shipmentEnterpriseReduceName;
    /** 物流商类型 1-物流 2-快递 */
    @ApiModelProperty(name="shipmentEnterpriseType",value = "物流商类型 1-物流 2-快递")
    private Long shipmentEnterpriseType;
    /** 打印方式  1-唯品打印 2-拼多多 3-菜鸟打印 4-普通打印 */
    @ApiModelProperty(name="printType",value = "打印方式  1-唯品打印 2-拼多多 3-菜鸟打印 4-普通打印")
    private Long printType;
    /** 辅助编码 */
    @ApiModelProperty(name="assistCode",value = "辅助编码")
    private String assistCode;
    /** 体积系数 */
    @ApiModelProperty(name="volumeRatio",value = "体积系数")
    private BigDecimal volumeRatio;
    /** 联系人 */
    @ApiModelProperty(name="contact",value = "联系人")
    private String contact;
    /** 联系方式 */
    @ApiModelProperty(name="contactPhone",value = "联系方式")
    private String contactPhone;
    /** 邮箱 */
    @ApiModelProperty(name="email",value = "邮箱")
    private String email;
    /** 状态  1-有效 0-无效 */
    @ApiModelProperty(name="shipmentEnterpriseStatus",value = "状态  1-有效 0-无效")
    private Long shipmentEnterpriseStatus;
    /** 联系地址 */
    @ApiModelProperty(name="contactAddress",value = "联系地址")
    private String contactAddress;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "province", value = "省份名称")
    private String province;
    /**
     *  省份编码
     */
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;
    /**
     *  地市编码
     */
    @ApiModelProperty(name = "cityCode", value = "地市编码")
    private String cityCode;
    /**
     *  地市
     */
    @ApiModelProperty(name = "city", value = "地市")
    private String city;
    /**
     *  区编码
     */
    @ApiModelProperty(name = "countyCode", value = "区编码")
    private String countyCode;
    /**
     *  区
     */
    @ApiModelProperty(name = "county", value = "区名称")
    private String county;

    /**
     *  承运方式(多个使用逗号分隔),0-海运,1-整车,2-整担
     */
    @ApiModelProperty(name = "logisticsType", value = "承运方式(多个使用逗号分隔),0-海运,1-整车,2-整担")
    private String logisticsType;

    @ApiModelProperty(name="customerName",value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "customerCode",value = "客户编码")
    private String customerCode;


    public String getLogisticsType() {
        return logisticsType;
    }

    public void setLogisticsType(String logisticsType) {
        this.logisticsType = logisticsType;
    }

    public String getShipmentEnterpriseCode() {
        return shipmentEnterpriseCode;
    }

    public void setShipmentEnterpriseCode(String shipmentEnterpriseCode) {
        this.shipmentEnterpriseCode = shipmentEnterpriseCode;
    }

    public String getShipmentEnterpriseName() {
        return shipmentEnterpriseName;
    }

    public void setShipmentEnterpriseName(String shipmentEnterpriseName) {
        this.shipmentEnterpriseName = shipmentEnterpriseName;
    }

    public String getShipmentEnterpriseReduceName() {
        return shipmentEnterpriseReduceName;
    }

    public void setShipmentEnterpriseReduceName(String shipmentEnterpriseReduceName) {
        this.shipmentEnterpriseReduceName = shipmentEnterpriseReduceName;
    }

    public Long getShipmentEnterpriseType() {
        return shipmentEnterpriseType;
    }

    public void setShipmentEnterpriseType(Long shipmentEnterpriseType) {
        this.shipmentEnterpriseType = shipmentEnterpriseType;
    }

    public Long getPrintType() {
        return printType;
    }

    public void setPrintType(Long printType) {
        this.printType = printType;
    }

    public String getAssistCode() {
        return assistCode;
    }

    public void setAssistCode(String assistCode) {
        this.assistCode = assistCode;
    }

    public BigDecimal getVolumeRatio() {
        return volumeRatio;
    }

    public void setVolumeRatio(BigDecimal volumeRatio) {
        this.volumeRatio = volumeRatio;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getShipmentEnterpriseStatus() {
        return shipmentEnterpriseStatus;
    }

    public void setShipmentEnterpriseStatus(Long shipmentEnterpriseStatus) {
        this.shipmentEnterpriseStatus = shipmentEnterpriseStatus;
    }

    public String getContactAddress() {
        return contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
}