/**
 * @(#)CsVirtualInventoryQueryDto.java 1.0 2022/06/17 14:45
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BaseRequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jingran
 * @Description CsVirtualInventoryQueryDto
 * @Date: 2022/06/17 14:45
 * @since 1.0.0
 */
@ApiModel(value = "csVirtualInventoryQueryDto", description = "查询Dto")
public class CsVirtualInventoryQueryDto implements Serializable {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 批次类型 common-正常,defective-残次品,其他类型待定
     */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
     * 总库存
     */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
     * 预占库存
     */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
     * 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
     */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     * 版本：0.迁移旧数据，1.一期迭代二，2.二期
     */
    @ApiModelProperty(name = "version", value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getBatchType() {
        return batchType;
    }

    public void setBatchType(String batchType) {
        this.batchType = batchType;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}