/**
 * @(#)CsChannelWarehouseQueryDto.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.Date;

/**
* @Description CsChannelWarehouseQueryDto
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@ApiModel(value = "csChannelWarehouseQueryDto", description = "查询Dto")
public class CsChannelWarehouseQueryDto extends RequestDto {
    @ApiModelProperty(name="commonQuery",value = "通用查询字段")
    private String commonQuery;
    /** 渠道ID **/
    @ApiModelProperty(name="channelId",value = "渠道ID")
    private Long channelId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "渠道仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 逻辑仓库编码 */
    @ApiModelProperty(name="logicWarehouseCode",value = "逻辑仓库编码")
    private String logicWarehouseCode;
    /** 逻辑仓库名称 */
    @ApiModelProperty(name="logicWarehouseName",value = "逻辑仓库名称")
    private String logicWarehouseName;
    /** 仓库状态 initial-初始,enable-启用,disable-停用 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;
    @ApiModelProperty(name="logicWarehouseStatus",value = "逻辑仓库状态 initial-初始,enable-启用,disable-停用")
    private String logicWarehouseStatus;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    /** 渠道编码 */
    @ApiModelProperty(name="channelCode",value = "渠道编码")
    private String channelCode;
    /** 渠道名称 */
    @ApiModelProperty(name="channelName",value = "渠道名称")
    private String channelName;
    /** 渠道状态 */
    @ApiModelProperty(name="channelStatus",value = "渠道状态")
    private String channelStatus;

    @ApiModelProperty(name = "shopChannelId", value = "订单渠道id")
    private Long shopChannelId;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getCommonQuery() {
        return commonQuery;
    }

    public void setCommonQuery(String commonQuery) {
        this.commonQuery = commonQuery;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getLogicWarehouseName() {
        return logicWarehouseName;
    }

    public void setLogicWarehouseName(String logicWarehouseName) {
        this.logicWarehouseName = logicWarehouseName;
    }

    public String getLogicWarehouseStatus() {
        return logicWarehouseStatus;
    }

    public void setLogicWarehouseStatus(String logicWarehouseStatus) {
        this.logicWarehouseStatus = logicWarehouseStatus;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelStatus() {
        return channelStatus;
    }

    public void setChannelStatus(String channelStatus) {
        this.channelStatus = channelStatus;
    }

    public Long getShopChannelId() {
        return shopChannelId;
    }

    public void setShopChannelId(Long shopChannelId) {
        this.shopChannelId = shopChannelId;
    }
}
