/**
 * @(#)CsChannelWarehouseQueryDto.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.request.PcpShopReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* @Description CsChannelWarehouseQueryDto
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@ApiModel(value = "csChannelWarehouseQueryDto", description = "查询Dto")
public class CsChannelWarehouseShopAddQueryDto extends PcpOrderChannelReqDto {
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
