/**
 * @(#)CsLogicWarehouseAddReqDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* @Description CsLogicWarehouseAddReqDto
*
* @author jingran
* @Date: 2021/12/29 11:12
* @since 1.0.0
*/
@ApiModel(value = "csLogicWarehouseAddReqDto", description = "新增Dto")
public class CsLogicWarehouseAddReqDto extends BaseReqDto {

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库类型,待定 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型,待定")
    private String warehouseType;
    /** 仓库状态 initial-初始,enable-有效,disable-无效 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 仓库质量 1-合格 0-不合格*/
    @ApiModelProperty(name="warehouseQuality",value = "仓库质量")
    private Integer warehouseQuality;
    /** 仓库属性*/
    @ApiModelProperty(name="warehouseProperty",value = "仓库属性")
    private String warehouseProperty;
    /** 物理仓编码 */
    @ApiModelProperty(name = "physicsWarehouseCode",value = "物理仓编码")
    private String physicsWarehouseCode;
    /** 物理仓名称 */
    @ApiModelProperty(name = "physicsWarehouseName",value = "物理仓名称")
    private String physicsWarehouseName;
    /** EAS仓库ID */
    @ApiModelProperty(name = "easWarehouseId",value = "EAS仓库ID")
    private String easWarehouseId;
    /** 线上、线下 1-线上  2-线下 */
    @ApiModelProperty(name = "warehouseOnlineFlag",value = "线上、线下")
    private Integer warehouseOnlineFlag;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    /** spa工厂 */
    @ApiModelProperty(name = "sapFactory",value = "spa工厂")
    private String sapFactory;

    /** sap库位 */
    @ApiModelProperty(name = "sapStorageLocation",value = "sap库位")
    private String sapStorageLocation;

    /** 是否允许负库存 0-不允许 1-允许 */
    @ApiModelProperty(name = "negativeFlag",value = "是否允许负库存 0-不允许 1-允许")
    private Integer negativeFlag;

    /** 是否允许负库存 0-不允许 1-允许 */
    @ApiModelProperty(name = "warehouseIsNegative",value = "是否允许负库存 0-不允许 1-允许")
    private Integer warehouseIsNegative;

    /** 渠道类型 */
    @ApiModelProperty(name = "channel_type",value = "渠道类型")
    private String channelType;

    @ApiModelProperty(name="warehouseAddress",value = "地址信息")
    private CsWarehouseAddressAddReqDto warehouseAddress;

    /** 联系人 */
    @ApiModelProperty(name="contact",value = "联系人")
    private String contact;
    /** 联系电话 */
    @ApiModelProperty(name="phone",value = "联系电话")
    private String phone;
    @ApiModelProperty(name="cargoEscheatageId",value = "货权组织编码")
    private String cargoEscheatageId;

    @ApiModelProperty(name="cargoEscheatageName",value = "货权组织名称")
    private String cargoEscheatageName;
    @ApiModelProperty(name="version",value = "默认二期")
    private Integer version = 2;
    public CsWarehouseAddressAddReqDto getWarehouseAddress() {
        return warehouseAddress;
    }

    public void setWarehouseAddress(CsWarehouseAddressAddReqDto warehouseAddress) {
        this.warehouseAddress = warehouseAddress;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSapFactory() {
        return sapFactory;
    }

    public void setSapFactory(String sapFactory) {
        this.sapFactory = sapFactory;
    }

    public String getSapStorageLocation() {
        return sapStorageLocation;
    }

    public void setSapStorageLocation(String sapStorageLocation) {
        this.sapStorageLocation = sapStorageLocation;
    }

    public Integer getNegativeFlag() {
        return negativeFlag;
    }

    public void setNegativeFlag(Integer negativeFlag) {
        this.negativeFlag = negativeFlag;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Integer getWarehouseIsNegative() {
        return warehouseIsNegative;
    }

    public void setWarehouseIsNegative(Integer warehouseIsNegative) {
        this.warehouseIsNegative = warehouseIsNegative;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(Integer warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getPhysicsWarehouseCode() {
        return physicsWarehouseCode;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getPhysicsWarehouseName() {
        return physicsWarehouseName;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public String getEasWarehouseId() {
        return easWarehouseId;
    }

    public void setEasWarehouseId(String easWarehouseId) {
        this.easWarehouseId = easWarehouseId;
    }

    public Integer getWarehouseOnlineFlag() {
        return warehouseOnlineFlag;
    }

    public void setWarehouseOnlineFlag(Integer warehouseOnlineFlag) {
        this.warehouseOnlineFlag = warehouseOnlineFlag;
    }

    public String getCargoEscheatageId() {
        return cargoEscheatageId;
    }

    public void setCargoEscheatageId(String cargoEscheatageId) {
        this.cargoEscheatageId = cargoEscheatageId;
    }

    public String getCargoEscheatageName() {
        return cargoEscheatageName;
    }

    public void setCargoEscheatageName(String cargoEscheatageName) {
        this.cargoEscheatageName = cargoEscheatageName;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }
}