/**
 * @(#)CsPhysicsWarehouseAddReqDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author jingran
 * @Description CsPhysicsWarehouseAddReqDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@ApiModel(value = "csLogicWarehouseExposedAddReqDto", description = "新增Dto")
public class CsLogicWarehouseExposedAddReqDto implements Serializable {

    /**
     * 仓库ID，编辑操作，ID必传
     */
    @ApiModelProperty(name = "id", value = "仓库ID，编辑操作，ID必传")
    private Long id;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;

    /**
     * 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓
     */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify = CsWarehouseClassifyEnum.LOGIC.getCode();

    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;

    /**
     * 仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other ")
    private String warehouseQuality;

    /**
     * 所属物理仓仓库ID
     */
    @ApiModelProperty(name = "subordinatePhysicsWarehouseId", value = "所属物理仓仓库ID")
    private Long subordinatePhysicsWarehouseId;

    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    /**
     * 所属逻辑仓名称
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓(名称)")
    private String subordinateLogicWarehouseName;

    /**
     * 仓库属性
     * <p>
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehousePropertyEnum
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /**
     * eas仓库编码
     */
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 线上线下标识，线上-on_line   线下-off_line
     */
    @ApiModelProperty(name = "warehouseOnlineFlag", value = "线上线下标识，线上-on_line   线下-off_line")
    private String warehouseOnlineFlag;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 货权组织名称。货品归属权的组织
     */
    @ApiModelProperty(name = "cargoEscheatageName", value = "货权组织名称。货品归属权的组织")
    private String cargoEscheatageName;

    /**
     * 货权组织ID。货品归属权的组织
     */
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID。货品归属权的组织")
    private String cargoEscheatageId;

    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    /**
     * 是否默认退货仓：1.是，0.否
     */
    @ApiModelProperty(name = "isReturnWarehouse", value = "是否默认退货仓：1.是，0.否")
    private Integer isReturnWarehouse;

    /**
     * 转合格入库仓
     */
    @ApiModelProperty(name = "inQualifyWarehouse", value = "转合格入库仓")
    private String inQualifyWarehouse;

    /**
     * 近效期调入仓
     */
    @ApiModelProperty(name = "inNearExpireWarehouse", value = "近效期调入仓")
    private String inNearExpireWarehouse;

    /**
     * 虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）
     */
    @ApiModelProperty(name = "isVirtual", value = "虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）")
    private Integer isVirtual;

    public String getWarehouseCorrespondingSystem() {
        return warehouseCorrespondingSystem;
    }

    public void setWarehouseCorrespondingSystem(String warehouseCorrespondingSystem) {
        this.warehouseCorrespondingSystem = warehouseCorrespondingSystem;
    }

    @ApiModelProperty(name = "warehouseCorrespondingSystem", value = "仓库对应系统")
    private String warehouseCorrespondingSystem;


    public String getSubordinateLogicWarehouseName() {
        return subordinateLogicWarehouseName;
    }

    public void setSubordinateLogicWarehouseName(String subordinateLogicWarehouseName) {
        this.subordinateLogicWarehouseName = subordinateLogicWarehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getSubordinateLogicWarehouseId() {
        return subordinateLogicWarehouseId;
    }

    public void setSubordinateLogicWarehouseId(Long subordinateLogicWarehouseId) {
        this.subordinateLogicWarehouseId = subordinateLogicWarehouseId;
    }

    public String getInQualifyWarehouse() {
        return inQualifyWarehouse;
    }

    public void setInQualifyWarehouse(String inQualifyWarehouse) {
        this.inQualifyWarehouse = inQualifyWarehouse;
    }

    public String getInNearExpireWarehouse() {
        return inNearExpireWarehouse;
    }

    public void setInNearExpireWarehouse(String inNearExpireWarehouse) {
        this.inNearExpireWarehouse = inNearExpireWarehouse;
    }

    public Integer getIsVirtual() {
        return isVirtual;
    }

    public void setIsVirtual(Integer isVirtual) {
        this.isVirtual = isVirtual;
    }

    public Integer getIsReturnWarehouse() {
        return isReturnWarehouse;
    }

    public void setIsReturnWarehouse(Integer isReturnWarehouse) {
        this.isReturnWarehouse = isReturnWarehouse;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public CsLogicWarehouseExposedAddReqDto() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(String warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public Long getSubordinatePhysicsWarehouseId() {
        return subordinatePhysicsWarehouseId;
    }

    public void setSubordinatePhysicsWarehouseId(Long subordinatePhysicsWarehouseId) {
        this.subordinatePhysicsWarehouseId = subordinatePhysicsWarehouseId;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }

    public String getWarehouseOnlineFlag() {
        return warehouseOnlineFlag;
    }

    public void setWarehouseOnlineFlag(String warehouseOnlineFlag) {
        this.warehouseOnlineFlag = warehouseOnlineFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCargoEscheatageName() {
        return cargoEscheatageName;
    }

    public void setCargoEscheatageName(String cargoEscheatageName) {
        this.cargoEscheatageName = cargoEscheatageName;
    }

    public String getCargoEscheatageId() {
        return cargoEscheatageId;
    }

    public void setCargoEscheatageId(String cargoEscheatageId) {
        this.cargoEscheatageId = cargoEscheatageId;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }
}