/**
 * @(#)CsPhysicsWarehouseQueryDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 逻辑仓分页查询请求DTO
 *
 * @author jingran
 * @Description CsPhysicsWarehouseQueryDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@ApiModel(value = "CsLogicWarehousePageQueryDto", description = "逻辑仓分页查询请求DTO")
@Data
public class CsLogicWarehousePageQueryDto extends BasePageDto implements Serializable {
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 仓库属性：产成品、半成品、专柜、第三方、产成品/促销物料、促销物料
     **/
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性集合")
    private List<String> warehouseProperty;

    /**
     * 仓库品质，待检-wait_inspection   不合格-un_qualified   合格-qualified    待处理-pending  其他-other
     **/
    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质,待检-wait_inspection   不合格-un_qualified   合格-qualified    待处理-pending  其他-other")
    private String warehouseQuality;

    /** 货权组织ID。货品归属权的组织 */
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID。货品归属权的组织")
    private String cargoEscheatageId;

    /** 货权组织名称。货品归属权的组织名称 */
    @ApiModelProperty(name = "cargoEscheatageName", value = "货权组织名称。货品归属权的组织名称")
    private String cargoEscheatageName;

    /** 所属物理仓仓库ID */
    @ApiModelProperty(name = "subordinatePhysicsWarehouseId", value = "所属物理仓仓库ID")
    private Long subordinatePhysicsWarehouseId;

    @ApiModelProperty(name = "shopChannelId", value = "所属订单渠道id")
    private Long shopChannelId;

    @ApiModelProperty(name = "channelWarehouseCode",value = "所属渠道仓编码")
    private String channelWarehouseCode;

    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;

    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;
    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓(名称)")
    private String subordinateLogicWarehouseName;

    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码集合")
    private Set<String> warehouseCodeList;

    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;

    @ApiModelProperty(name = "warehouseType", value = "线上/线下")
    @JsonProperty("channelType")
    private String channelType;

    private Integer ifNearlyEffective;

    @ApiModelProperty(name = "warehouseCorrespondingSystem", value = "仓库对应系统")
    private String warehouseCorrespondingSystem;

}