/**
 * @(#)CsPhysicsWarehouseQueryDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 逻辑仓参数查询请求DTO
 *
 * @author jingran
 * @Description CsLogicWarehouseParamQueryDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "CsLogicWarehouseParamQueryDto", description = "逻辑仓参数查询请求DTO")
public class CsLogicWarehouseParamQueryDto extends BasePageDto implements Serializable {
    /**
     * 仓库编码集合
     **/
    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码集合")
    private List<String> warehouseCodeList;
    /**
     * 仓库ID集合
     **/
    @ApiModelProperty(name = "warehouseIdList", value = "仓库ID集合")
    private List<Long> warehouseIdList;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 仓库属性：产成品、半成品、专柜、第三方、产成品/促销物料、促销物料
     **/
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /** 所属物理仓仓库ID */
    @ApiModelProperty(name = "subordinatePhysicsWarehouseId", value = "所属物理仓仓库ID")
    private Long subordinatePhysicsWarehouseId;

    /** 是否查询关联的物理仓信息 0-不查询(默认)  1-查询 **/
    @ApiModelProperty(name = "queryRelPhysicsWarehouse", value = " 是否查询关联的物理仓信息 0-不查询(默认)  1-查询")
    private Integer queryRelPhysicsWarehouse;

    /**
     * 货权组织ID
     **/
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID")
    private String cargoEscheatageId;

    /** 组织编码 */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    /** 组织编码 */
    @ApiModelProperty(name = "organizationId", value = "组织编码")
    private Long organizationId;

    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;
    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓(名称)")
    private String subordinateLogicWarehouseName;

}