/**
 * @(#)CsLogicWarehouseUpdateReqDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* @Description CsLogicWarehouseUpdateReqDto
*
* @author jingran
* @Date: 2021/12/29 11:12
* @since 1.0.0
*/
@ApiModel(value = "csLogicWarehouseUpdateReqDto", description = "修改Dto")
public class CsLogicWarehouseUpdateReqDto extends BaseReqDto {

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库类型,待定 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型,待定")
    private String warehouseType;
    /** 仓库状态 initial-初始,enable-有效,disable-无效 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /** 联系人 */
    @ApiModelProperty(name="contact",value = "联系人")
    private String contact;
    /** 联系电话 */
    @ApiModelProperty(name="phone",value = "联系电话")
    private String phone;
    /** 仓库质量 1-合格 0-不合格*/
    @ApiModelProperty(name="warehouseQuality",value = "仓库质量")
    private Integer warehouseQuality;
    /** 仓库属性*/
    @ApiModelProperty(name="warehouseProperty",value = "仓库属性")
    private String warehouseProperty;
    /** 物理仓编码 */
    @ApiModelProperty(name = "physicsWarehouseCode",value = "物理仓编码")
    private String physicsWarehouseCode;
    /** 物理仓名称 */
    @ApiModelProperty(name = "physicsWarehouseName",value = "物理仓名称")
    private String physicsWarehouseName;
    /** EAS仓库ID */
    @ApiModelProperty(name = "easWarehouseId",value = "EAS仓库ID")
    private String easWarehouseId;
    /** 线上、线下 1-线上  2-线下 */
    @ApiModelProperty(name = "warehouseOnlineFlag",value = "线上、线下")
    private Integer warehouseOnlineFlag;

    @ApiModelProperty(name="cargoEscheatageId",value = "货权组织编码")
    private String cargoEscheatageId;

    @ApiModelProperty(name="cargoEscheatageName",value = "货权组织名称")
    private String cargoEscheatageName;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(Integer warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getPhysicsWarehouseCode() {
        return physicsWarehouseCode;
    }

    public void setPhysicsWarehouseCode(String physicsWarehouseCode) {
        this.physicsWarehouseCode = physicsWarehouseCode;
    }

    public String getPhysicsWarehouseName() {
        return physicsWarehouseName;
    }

    public void setPhysicsWarehouseName(String physicsWarehouseName) {
        this.physicsWarehouseName = physicsWarehouseName;
    }

    public String getEasWarehouseId() {
        return easWarehouseId;
    }

    public void setEasWarehouseId(String easWarehouseId) {
        this.easWarehouseId = easWarehouseId;
    }

    public Integer getWarehouseOnlineFlag() {
        return warehouseOnlineFlag;
    }

    public void setWarehouseOnlineFlag(Integer warehouseOnlineFlag) {
        this.warehouseOnlineFlag = warehouseOnlineFlag;
    }

    public String getCargoEscheatageId() {
        return cargoEscheatageId;
    }

    public void setCargoEscheatageId(String cargoEscheatageId) {
        this.cargoEscheatageId = cargoEscheatageId;
    }

    public String getCargoEscheatageName() {
        return cargoEscheatageName;
    }

    public void setCargoEscheatageName(String cargoEscheatageName) {
        this.cargoEscheatageName = cargoEscheatageName;
    }
}