/**
 * @(#)CsPhysicsWarehouseAddReqDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author jingran
 * @Description CsPhysicsWarehouseAddReqDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@ApiModel(value = "csPhysicsWarehouseAddReqDto", description = "新增Dto")
public class CsPhysicsWarehouseAddReqDto implements Serializable {

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓")
    private String warehouseType;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     */
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * eas仓库编码
     */
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRdcFlag() {
        return rdcFlag;
    }

    public void setRdcFlag(String rdcFlag) {
        this.rdcFlag = rdcFlag;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }
}