/**
 * @(#)CsWarehouseAddressQueryDto.java 1.0 2022/01/10 11:31
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
* @Description CsWarehouseAddressParamQueryDto
*
* @author jingran
* @Date: 2022/01/10 11:31
* @since 1.0.0
*/
@ApiModel(value = "CsWarehouseAddressParamQueryDto", description = "参数查询DTO")
public class CsWarehouseAddressParamQueryDto implements Serializable {

    /** 仓库ID集合 **/
    @ApiModelProperty(name="warehouseIdList",value = "仓库ID集合")
    private List<Long> warehouseIdList;
    /** 仓库编码集合 **/
    @ApiModelProperty(name="warehouseCodeList",value = "仓库编码集合")
    private List<String> warehouseCodeList;
    /** 仓库ID **/
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 **/
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 发货仓库名称 **/
    @ApiModelProperty(name="warehouseName",value = "发货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 **/
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 是否有效 enable-有效 disable-无效 **/
    @ApiModelProperty(name="validFlag",value = "是否有效 enable-有效 disable-无效")
    private String validFlag;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(String validFlag) {
        this.validFlag = validFlag;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public List<Long> getWarehouseIdList() {
        return warehouseIdList;
    }

    public void setWarehouseIdList(List<Long> warehouseIdList) {
        this.warehouseIdList = warehouseIdList;
    }

    public List<String> getWarehouseCodeList() {
        return warehouseCodeList;
    }

    public void setWarehouseCodeList(List<String> warehouseCodeList) {
        this.warehouseCodeList = warehouseCodeList;
    }
}