package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 *
 * 库存分页查询基础响应DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/12 10:49 上午
 */
public class CsInventoryBasicsPageQueryRespDto extends BaseRespDto {
    /** 长编码 */
    @ApiModelProperty(name="LongCode",value = "长编码")
    private String LongCode;

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;

    /** 生产日期 */
    @ApiModelProperty(name="produceTime",value = "生产日期")
    private Date produceTime;

    /** 过期日期 */
    @ApiModelProperty(name="expireTime",value = "过期日期")
    private Date expireTime;

    /** 即时库存 */
    @ApiModelProperty(name="balance",value = "即时库存")
    private BigDecimal balance;

    /** 预占库存(锁定库存) */
    @ApiModelProperty(name="preempt",value = "预占库存(锁定库存) ")
    private BigDecimal preempt;

    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;
    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;
    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;
    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;
    /** 已完成库存 */
    @ApiModelProperty(name="completed",value = "已完成库存")
    private BigDecimal completed;
    /** 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存 */
    @ApiModelProperty(name="available",value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;

    /** 仓库分类  物理仓-physics  逻辑仓-logic  虚拟仓-virtual  渠道仓-channel  */
    @ApiModelProperty(name="warehouseClassify",value = "仓库编码")
    private String warehouseClassify;

    public String getLongCode() {
        return LongCode;
    }

    public void setLongCode(String longCode) {
        LongCode = longCode;
    }

    public CsInventoryBasicsPageQueryRespDto() {
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getActivityAllocate() {
        return activityAllocate;
    }

    public void setActivityAllocate(BigDecimal activityAllocate) {
        this.activityAllocate = activityAllocate;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getTransfer() {
        return transfer;
    }

    public void setTransfer(BigDecimal transfer) {
        this.transfer = transfer;
    }

    public BigDecimal getCompleted() {
        return completed;
    }

    public void setCompleted(BigDecimal completed) {
        this.completed = completed;
    }
}
