/**
 * @(#)CsInventoryPreemptionRespDto.java 1.0 2022/02/14 15:22
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* @Description CsInventoryPreemptionRespDto
*
* @author jingran
* @Date: 2022/02/14 15:22
* @since 1.0.0
*/
@ApiModel(value = "csInventoryPreemptionRespDto", description = "返回信息Dto")
@Data
public class CsInventoryPreemptionRespDto extends BaseRespDto {

    /** 单据类型,待定 */
    @ApiModelProperty(name="sourceType",value = "单据类型,待定")
    private String sourceType;
    /** 来源单据号 */
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;
    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 批次类型 common-正常,defective-残次品,其他类型待定 */
    @ApiModelProperty(name="batchType",value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /** enable有效,disable无效 */
    @ApiModelProperty(name="valid",value = "enable有效,disable无效")
    private String valid;
    /** 活动ID */
    @ApiModelProperty(name="activityId",value = "活动ID")
    private Long activityId;
    /** 活动类型 */
    @ApiModelProperty(name="activityType",value = "活动类型")
    private String activityType;
    /** 是否为活动商品  0-否  1-是 */
    @ApiModelProperty(name="activityFlag",value = "是否为活动商品  0-否  1-是")
    private Integer activityFlag;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /** 预占的货品数量 */
    @ApiModelProperty(name="preemptNum",value = "预占的货品数量")
    private BigDecimal preemptNum;

    @ApiModelProperty(name="lessNum",value = "缺货数量")
    private BigDecimal lessNum;

    /** 外部单号 */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;

    /** 货品长编码 */
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;
}
