/**
 * @(#)CsLockOrderRespDto.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsLockOrderRespDto
*
* @author wenyi
* @Date: 2022/05/30 15:48
* @since 1.0.0
*/
@ApiModel(value = "csLockOrderRespDto", description = "返回信息Dto")
public class CsLockOrderRespDto implements Serializable {
    private Long id;
    /** 逻辑仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "逻辑仓库编码")
    private String warehouseCode;
    /** 逻辑仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "逻辑仓库名称")
    private String warehouseName;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 当前锁库数量 */
    @ApiModelProperty(name="currentLockQuantity",value = "当前锁库数量")
    private BigDecimal currentLockQuantity;
    /** 人工锁库次数 */
    @ApiModelProperty(name="number",value = "人工锁库次数")
    private Integer number;
    /** 锁库原因 */
    @ApiModelProperty(name="remark",value = "锁库原因")
    private String remark;
    /** 商品类型：1-产品 2-赠品 3-促销物料 */
    @ApiModelProperty(name = "itemType",value = "商品类型：1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /** 仓库属性 */
    @ApiModelProperty(name = "warehouseProperty",value = "仓库属性")
    private String warehouseProperty;
    /** 可用库存（商品数量） */
    @ApiModelProperty(name = "available", value = "可用库存（商品数量）")
    private BigDecimal available;
    /** 过期日期 */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /** 生产日期 */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /** 库存组织 */
    @ApiModelProperty(name = "organizationName", value = "库存组织")
    private String organizationName;
    /** 入库时间 */
    @ApiModelProperty(name = "createTime", value = "入库时间")
    private Date createTime;
    /** 是否临期 */
    @ApiModelProperty(name = "isNearOverdue", value = "是否临期：1是，0否")
    private Integer isNearOverdue;
    /** 在库天数 */
    @ApiModelProperty(name = "inventoryDay", value = "在库天数")
    private Integer inventoryDay;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getCurrentLockQuantity() {
        return currentLockQuantity;
    }

    public void setCurrentLockQuantity(BigDecimal currentLockQuantity) {
        this.currentLockQuantity = currentLockQuantity;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Long getItemType() {
        return itemType;
    }

    public void setItemType(Long itemType) {
        this.itemType = itemType;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsNearOverdue() {
        return isNearOverdue;
    }

    public void setIsNearOverdue(Integer isNearOverdue) {
        this.isNearOverdue = isNearOverdue;
    }

    public Integer getInventoryDay() {
        return inventoryDay;
    }

    public void setInventoryDay(Integer inventoryDay) {
        this.inventoryDay = inventoryDay;
    }
}
