package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 质检转合格Eo对象
*
* @author 宁毅
* @since 2022-05-26
*/
@ApiModel(value = "CsQualityInfoDetailRespDto", description = "质检转合格Eo对象")
public class CsQualityInfoDetailRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  计划单号
    */
    @ApiModelProperty(name = "plannedOrderNo", value = "计划单号")
    private String plannedOrderNo;
    /**
    *  平台单号(来源于第三方系统)
    */
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     *  关联调拨单号
     */
    @ApiModelProperty(name = "transferOrderNo", value = "关联调拨单号")
    private String transferOrderNo;
    /**
    *  单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
    */
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
    *  业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
    */
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
    *  收货仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "收货仓库ID")
    private Long warehouseId;
    /**
    *  收货仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "收货仓库编码")
    private String warehouseCode;
    /**
    *  收货仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "收货仓库名称")
    private String warehouseName;
    /**
     *  放行仓库ID
     */
    @ApiModelProperty(name = "releaseWarehouseId", value = "放行仓库ID")
    private Long releaseWarehouseId;
    /**
     *  放行仓库编码
     */
    @ApiModelProperty(name = "releaseWarehouseCode", value = "放行仓库编码")
    private String releaseWarehouseCode;
    /**
     *  放行仓库名称
     */
    @ApiModelProperty(name = "releaseWarehouseName", value = "放行仓库名称")
    private String releaseWarehouseName;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
    *  商品数量
    */
    @ApiModelProperty(name = "quantity", value = "商品数量")
    private BigDecimal quantity;
    /**
    *  出库数量
    */
    @ApiModelProperty(name = "doneQuantity", value = "出库数量")
    private BigDecimal doneQuantity;
    /**
    *  接收报告时间
    */
    @ApiModelProperty(name = "reportTime", value = "接收报告时间")
    private Date reportTime;
    /**
     * 接收报告标识（1-已接受 0-未接收）
     */
    @ApiModelProperty(name = "receiveReportFlag", value = "接收报告标识（1-已接受 0-未接收）")
    private Integer  receiveReportFlag;
    /**
    *  质检报告,qualified-合格,disqualification-不合格
    */
    @ApiModelProperty(name = "reportResult", value = "质检报告,qualified-合格,disqualification-不合格")
    private String reportResult;
    /**
     *  检测报告URL
     */
    @ApiModelProperty(name = "reportResultUrl", value = "检测报告URL")
    private String reportResultUrl;
    /**
    *  推送WMS状态,success-成功,failure-失败
    */
    @ApiModelProperty(name = "pushWmsStatus", value = "推送WMS状态,success-成功,failure-失败")
    private String pushWmsStatus;
    /**
    *  放行状态：unPassed-是(待放行),passed-否(已放行)
    */
    @ApiModelProperty(name = "dischargedStatus", value = "放行状态：unPassed-是(待放行),passed-否(已放行)")
    private String dischargedStatus;
    /**
    *  超7天未放行,unPassed-是(未放行),passed-否(已放行)
    */
    @ApiModelProperty(name = "dischargedFlag", value = "超7天未放行,unPassed-是(未放行),passed-否(已放行)")
    private String dischargedFlag;
    /**
     *  放行时间
     */
    @ApiModelProperty(name = "dischargedTime", value = "放行时间")
    private Date dischargedTime;
    /**
    *  是否批次倒挂,upside-是(批次倒挂),common-否(正常)
    */
    @ApiModelProperty(name = "batchUpsideFlag", value = "是否批次倒挂,upside-是(批次倒挂),common-否(正常)")
    private String batchUpsideFlag;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     *  备注字体颜色
     */
    @ApiModelProperty(name = "remarkColour", value = "备注字体颜色")
    private String remarkColour;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setPlannedOrderNo(String plannedOrderNo){
    this.plannedOrderNo = plannedOrderNo;
    }
    public String getPlannedOrderNo(){
    return this.plannedOrderNo;
    }
    public void setPlatformOrderNo(String platformOrderNo){
    this.platformOrderNo = platformOrderNo;
    }
    public String getPlatformOrderNo(){
    return this.platformOrderNo;
    }
    public void setOrderType(String orderType){
    this.orderType = orderType;
    }
    public String getOrderType(){
    return this.orderType;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setWarehouseId(Long warehouseId){
    this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
    return this.warehouseId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setCargoId(Long cargoId){
    this.cargoId = cargoId;
    }
    public Long getCargoId(){
    return this.cargoId;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setExpireTime(Date expireTime){
    this.expireTime = expireTime;
    }
    public Date getExpireTime(){
    return this.expireTime;
    }
    public void setProduceTime(Date produceTime){
    this.produceTime = produceTime;
    }
    public Date getProduceTime(){
    return this.produceTime;
    }
    public void setQuantity(BigDecimal quantity){
    this.quantity = quantity;
    }
    public BigDecimal getQuantity(){
    return this.quantity;
    }
    public void setDoneQuantity(BigDecimal doneQuantity){
    this.doneQuantity = doneQuantity;
    }
    public BigDecimal getDoneQuantity(){
    return this.doneQuantity;
    }
    public void setReportTime(Date reportTime){
    this.reportTime = reportTime;
    }
    public Date getReportTime(){
    return this.reportTime;
    }
    public void setReportResult(String reportResult){
    this.reportResult = reportResult;
    }
    public String getReportResult(){
    return this.reportResult;
    }
    public void setPushWmsStatus(String pushWmsStatus){
    this.pushWmsStatus = pushWmsStatus;
    }
    public String getPushWmsStatus(){
    return this.pushWmsStatus;
    }
    public void setDischargedStatus(String dischargedStatus){
    this.dischargedStatus = dischargedStatus;
    }
    public String getDischargedStatus(){
    return this.dischargedStatus;
    }
    public void setDischargedFlag(String dischargedFlag){
    this.dischargedFlag = dischargedFlag;
    }
    public String getDischargedFlag(){
    return this.dischargedFlag;
    }
    public void setBatchUpsideFlag(String batchUpsideFlag){
    this.batchUpsideFlag = batchUpsideFlag;
    }
    public String getBatchUpsideFlag(){
    return this.batchUpsideFlag;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }

    public Date getDischargedTime() {
        return dischargedTime;
    }

    public void setDischargedTime(Date dischargedTime) {
        this.dischargedTime = dischargedTime;
    }

    public String getReportResultUrl() {
        return reportResultUrl;
    }

    public void setReportResultUrl(String reportResultUrl) {
        this.reportResultUrl = reportResultUrl;
    }

    public Long getReleaseWarehouseId() {
        return releaseWarehouseId;
    }

    public void setReleaseWarehouseId(Long releaseWarehouseId) {
        this.releaseWarehouseId = releaseWarehouseId;
    }

    public String getReleaseWarehouseCode() {
        return releaseWarehouseCode;
    }

    public void setReleaseWarehouseCode(String releaseWarehouseCode) {
        this.releaseWarehouseCode = releaseWarehouseCode;
    }

    public String getReleaseWarehouseName() {
        return releaseWarehouseName;
    }

    public void setReleaseWarehouseName(String releaseWarehouseName) {
        this.releaseWarehouseName = releaseWarehouseName;
    }

    public Integer getReceiveReportFlag() {
        return receiveReportFlag;
    }

    public void setReceiveReportFlag(Integer receiveReportFlag) {
        this.receiveReportFlag = receiveReportFlag;
    }

    public String getTransferOrderNo() {
        return transferOrderNo;
    }

    public void setTransferOrderNo(String transferOrderNo) {
        this.transferOrderNo = transferOrderNo;
    }

    public String getRemarkColour() {
        return remarkColour;
    }

    public void setRemarkColour(String remarkColour) {
        this.remarkColour = remarkColour;
    }
}
