package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 实时库存查询返回结果
 */
@Data
public class CsRealTimeInventoryRespDto {
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    @ApiModelProperty(name = "warehouseClassify", value = "仓库类型")
    private String warehouseClassify;
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    @ApiModelProperty(name = "expireTime", value = "过期时间")
    private Date expireTime;
    @ApiModelProperty(name = "expireDay", value = "效期预警（天）")
    private Integer expireDay;
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;
    @ApiModelProperty(name = "balance", value = "即时库存")
    private String balance;
    @ApiModelProperty(name = "available", value = "可用库存")
    private String available;
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private String preempt;
    @ApiModelProperty(name = "lock", value = "锁定库存")
    private String lock;
    @ApiModelProperty(name = "expire", value = "过期库存")
    private String expire;
    @ApiModelProperty(name = "inspect", value = "在途待检")
    private String inspect;
    @ApiModelProperty(name = "qualify", value = "在途合格")
    private String qualify;
    @ApiModelProperty(name = "intransit", value = "在途总数")
    private String intransit;
    @ApiModelProperty(name = "futureIn", value = "待收数")
    private String futureIn;
    @ApiModelProperty(name = "createTime", value = "创建日期")
    private Date createTime;
}
