package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 库存流水分页查询响应DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/16 10:41 下午
 */
@ApiModel(value="CsInventoryLogPageQueryReqDto",description = "库存流水分页查询DTO")
public class CsInventoryLogPageQueryRespDto extends BasePageDto implements Serializable {

    /** ID */
    @ApiModelProperty(name="id",value = "ID")
    private Long id;

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;

    /** 业务单据类型 */
    @ApiModelProperty(name="sourceType",value = "业务单据类型")
    private String sourceType;

    /** 前置单据号 */
    @ApiModelProperty(name="sourceNo",value = "前置单据号")
    private String sourceNo;

    /** 变动时间 */
    @ApiModelProperty(name="changeTime",value = "变动时间")
    private Date changeTime;

    /** 变动前即时库存 */
    @ApiModelProperty(name="beforeBalance",value = "变动前即时库存")
    private BigDecimal beforeBalance;
    /** 变动即时库存 */
    @ApiModelProperty(name="changeBalance",value = "变动即时库存")
    private BigDecimal changeBalance;
    /** 变动后即时库存 */
    @ApiModelProperty(name="afterBalance",value = "变动后即时库存")
    private BigDecimal afterBalance;
    /** 变动前锁定库存 */
    @ApiModelProperty(name="beforePreempt",value = "变动前锁定库存")
    private BigDecimal beforePreempt;
    /** 变动锁定库存 */
    @ApiModelProperty(name="changePreempt",value = "变动锁定库存")
    private BigDecimal changePreempt;
    /** 变动后锁定库存 */
    @ApiModelProperty(name="afterPreempt",value = "变动后锁定库存")
    private BigDecimal afterPreempt;
    /** 变动前可用库存 */
    @ApiModelProperty(name="beforeAvailable",value = "变动前可用库存")
    private BigDecimal beforeAvailable;
    /** 变动可用库存 */
    @ApiModelProperty(name="changeAvailable",value = "变动可用库存")
    private BigDecimal changeAvailable;
    /** 变动后可用库存 */
    @ApiModelProperty(name="afterAvailable",value = "变动后可用库存")
    private BigDecimal afterAvailable;

    public CsInventoryLogPageQueryRespDto() {
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getChangeBalance() {
        return changeBalance;
    }

    public void setChangeBalance(BigDecimal changeBalance) {
        this.changeBalance = changeBalance;
    }

    public BigDecimal getAfterBalance() {
        return afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getBeforePreempt() {
        return beforePreempt;
    }

    public void setBeforePreempt(BigDecimal beforePreempt) {
        this.beforePreempt = beforePreempt;
    }

    public BigDecimal getChangePreempt() {
        return changePreempt;
    }

    public void setChangePreempt(BigDecimal changePreempt) {
        this.changePreempt = changePreempt;
    }

    public BigDecimal getAfterPreempt() {
        return afterPreempt;
    }

    public void setAfterPreempt(BigDecimal afterPreempt) {
        this.afterPreempt = afterPreempt;
    }

    public BigDecimal getBeforeAvailable() {
        return beforeAvailable;
    }

    public void setBeforeAvailable(BigDecimal beforeAvailable) {
        this.beforeAvailable = beforeAvailable;
    }

    public BigDecimal getChangeAvailable() {
        return changeAvailable;
    }

    public void setChangeAvailable(BigDecimal changeAvailable) {
        this.changeAvailable = changeAvailable;
    }

    public BigDecimal getAfterAvailable() {
        return afterAvailable;
    }

    public void setAfterAvailable(BigDecimal afterAvailable) {
        this.afterAvailable = afterAvailable;
    }

}
