/**
 * @(#)CsInventoryLogRespDto.java 1.0 2022/01/10 10:47
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsInventoryLogRespDto
*
* @author jingran
* @Date: 2022/01/10 10:47
* @since 1.0.0
*/
@ApiModel(value = "csInventoryLogRespDto", description = "返回信息Dto")
@Data
public class CsInventoryLogRespDto extends BaseRespDto {

    /** 版本号 */
    @ApiModelProperty(name="version",value = "版本号")
    private String version;

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 批次类型 common-正常,defective-残次品,其他类型待定 */
    @ApiModelProperty(name="batchType",value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /** 变动前总库存 */
    @ApiModelProperty(name="beforeBalance",value = "变动前总库存")
    private BigDecimal beforeBalance;
    /** 变动总库存 */
    @ApiModelProperty(name="changeBalance",value = "变动总库存")
    private BigDecimal changeBalance;
    /** 变动后总库存 */
    @ApiModelProperty(name="afterBalance",value = "变动后总库存")
    private BigDecimal afterBalance;
    /** 变动前预占库存 */
    @ApiModelProperty(name="beforePreempt",value = "变动前预占库存")
    private BigDecimal beforePreempt;
    /** 变动预占库存 */
    @ApiModelProperty(name="changePreempt",value = "变动预占库存")
    private BigDecimal changePreempt;
    /** 变动后预占库存 */
    @ApiModelProperty(name="afterPreempt",value = "变动后预占库存")
    private BigDecimal afterPreempt;
    /** 变动前已分配库存 */
    @ApiModelProperty(name="beforeAllocate",value = "变动前已分配库存")
    private BigDecimal beforeAllocate;
    /** 变动已分配库存 */
    @ApiModelProperty(name="changeAllocate",value = "变动已分配库存")
    private BigDecimal changeAllocate;
    /** 变动后已分配库存 */
    @ApiModelProperty(name="afterAllocate",value = "变动后已分配库存")
    private BigDecimal afterAllocate;
    /** 变动前活动分配库存 */
    @ApiModelProperty(name="beforeActivityAllocate",value = "变动前活动分配库存")
    private BigDecimal beforeActivityAllocate;
    /** 变动活动分配库存 */
    @ApiModelProperty(name="changeActivityAllocate",value = "变动活动分配库存")
    private BigDecimal changeActivityAllocate;
    /** 变动后活动分配库存 */
    @ApiModelProperty(name="afterActivityAllocate",value = "变动后活动分配库存")
    private BigDecimal afterActivityAllocate;
    /** 变动前在途库存 */
    @ApiModelProperty(name="beforeIntransit",value = "变动前在途库存")
    private BigDecimal beforeIntransit;
    /** 变动在途库存 */
    @ApiModelProperty(name="changeIntransit",value = "变动在途库存")
    private BigDecimal changeIntransit;
    /** 变动后在途库存 */
    @ApiModelProperty(name="afterIntransit",value = "变动后在途库存")
    private BigDecimal afterIntransit;
    /** 变动前已调拨库存 */
    @ApiModelProperty(name="beforeTransfer",value = "变动前已调拨库存")
    private BigDecimal beforeTransfer;
    /** 变动已调拨库存 */
    @ApiModelProperty(name="changeTransfer",value = "变动已调拨库存")
    private BigDecimal changeTransfer;
    /** 变动后已调拨库存 */
    @ApiModelProperty(name="afterTransfer",value = "变动后已调拨库存")
    private BigDecimal afterTransfer;
    /** 变动前已完成库存 */
    @ApiModelProperty(name="beforeCompleted",value = "变动前已完成库存")
    private BigDecimal beforeCompleted;
    /** 变动已完成库存 */
    @ApiModelProperty(name="changeCompleted",value = "变动已完成库存")
    private BigDecimal changeCompleted;
    /** 变动后已完成库存 */
    @ApiModelProperty(name="afterCompleted",value = "变动后已完成库存")
    private BigDecimal afterCompleted;
    /** 变动前可用库存 */
    @ApiModelProperty(name="beforeAvailable",value = "变动前可用库存")
    private BigDecimal beforeAvailable;
    /** 变动可用库存 */
    @ApiModelProperty(name="changeAvailable",value = "变动可用库存")
    private BigDecimal changeAvailable;
    /** 变动后可用库存 */
    @ApiModelProperty(name="afterAvailable",value = "变动后可用库存")
    private BigDecimal afterAvailable;
    /** 变动前锁定库存 */
    @ApiModelProperty(name = "before_lock_inventory",value = "变动前锁定库存")
    private BigDecimal beforeLockInventory;
    /** 变动锁定库存 */
    @ApiModelProperty(name = "change_lock_inventory",value = "变动锁定库存")
    private BigDecimal changeLockInventory;
    /** 变动后锁定库存 */
    @ApiModelProperty(name = "after_lock_inventory",value = "变动后锁定库存")
    private BigDecimal afterLockInventory;
    /** 单据类型库存类型 */
    @ApiModelProperty(name="sourceType",value = "单据类型(库存类型)")
    private String sourceType;
    /** 来源单据号 */
    @ApiModelProperty(name="sourceNo",value = "来源单据号")
    private String sourceNo;
    /** 外部单号/平台单号 */
    @ApiModelProperty(name="externalSourceNo",value = "外部单号/平台单号 ")
    private String externalSourceNo;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 变动时间 */
    @ApiModelProperty(name="changeTime",value = "变动时间")
    private Date changeTime;
    /** 出入库标识  in-入库  out-出库 */
    @ApiModelProperty(name="inOutFlag",value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /** ID */
    @ApiModelProperty(name="id",value = "ID")
    private Long id;

    @ApiModelProperty(name = "supplyChangeNum", value = "供货变更数量")
    private BigDecimal supplyChangeNum;
}
