/**
 * @(#)CsBasisOrderRelOrderInfoRespDto.java 1.0 2022/04/26 17:27
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author wenyi
 * @Description CsBasisOrderRelOrderInfoRespDto
 * @Date: 2022/04/26 17:27
 * @since 1.0.0
 */
@ApiModel(value = "CsBasisOrderRelOrderInfoRespDto", description = "基础单据-关联单据信息DTO")
public class CsBasisOrderRelOrderInfoRespDto extends BaseRespDto {
    /**
     * 平台单号
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据号,系统生成的计划类单据号
     **/
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /**
     * 单据状态
     **/
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
     * 基础单据号
     **/
    @ApiModelProperty(name = "documentNo", value = "基础单据号")
    private String documentNo;
    /**
     * 基础单据类型 com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum
     **/
    @ApiModelProperty(name = "orderType", value = "基础单据类型")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
     * 基础单据状态
     **/
    @ApiModelProperty(name = "documentOrderStatus", value = "基础单据状态")
    private String documentOrderStatus;
    /**
     * 物流单号（存储母单号）
     */
    @ApiModelProperty(name = "shippingCode", value = "物流单号")
    private String shippingCode;
    /**
     * 承运方式
     */
    @ApiModelProperty(name = "shippingType", value = "承运方式")
    private String shippingType;
    /**
     * 物流商
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流商")
    private String shippingCompany;
    /**
     * wms单号
     **/
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号")
    private String wmsOrderNo;
    /**
     * 预计到货时间
     */
    @ApiModelProperty(name = "estimatedTime", value = "预计到货时间")
    private Date estimatedTime;

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getDocumentOrderStatus() {
        return documentOrderStatus;
    }

    public void setDocumentOrderStatus(String documentOrderStatus) {
        this.documentOrderStatus = documentOrderStatus;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public Date getEstimatedTime() {
        return estimatedTime;
    }

    public void setEstimatedTime(Date estimatedTime) {
        this.estimatedTime = estimatedTime;
    }
}
