/**
 * @(#)CsDeliveryNoticeOrderRespDto.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

//

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsDeliveryNoticeOrderRespDto
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@ApiModel(value = "csDeliveryNoticeOrderRespDto", description = "返回信息Dto")
public class CsDeliveryNoticeOrderRespDto extends BaseRespDto {

    /**
     * 发、收货通知单号
     */
    @ApiModelProperty(name = "documentNo", value = "发、收货通知单号")
    private String documentNo;
    /**
     * wms单号
     */
    @Deprecated
    @ApiModelProperty(name = "wmsNo", value = "wms单号")
    private String wmsNo;
    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    /**
     * 单据状态,待定
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;
    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     * 仓库ID
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库分类,physics-物理仓,logic-逻辑仓
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
     * 收货仓库ID
     */
    @Deprecated
    @ApiModelProperty(name = "receiveWarehouseId", value = "收货仓库ID")
    private Long receiveWarehouseId;
    /**
     * 收货仓库编码
     */
    @Deprecated
    @ApiModelProperty(name = "receiveWarehouseCode", value = "收货仓库编码")
    private String receiveWarehouseCode;
    /**
     * 收货仓库名称
     */
    @Deprecated
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称")
    private String receiveWarehouseName;
    /**
     * 收货仓库分类,physics-物理仓,logic-逻辑仓
     */
    @Deprecated
    @ApiModelProperty(name = "receiveWarehouseClassify", value = "收货仓库分类,physics-物理仓,logic-逻辑仓")
    private String receiveWarehouseClassify;
    /**
     * 发货逻辑仓库编码
     */
    @ApiModelProperty(name = "deliveryLogicWarehouseCode", value = "发货逻辑仓库编码")
    private String deliveryLogicWarehouseCode;
    /**
     * 发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryLogicWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryLogicWarehouseName;
    /**
     * 收货逻辑仓库编码
     */
    @ApiModelProperty(name = "receiveLogicWarehouseCode", value = "收货逻辑仓库编码")
    private String receiveLogicWarehouseCode;
    /**
     * 收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveLogicWarehouseName", value = "收货逻辑仓库名称")
    private String receiveLogicWarehouseName;
    /**
     * 发货逻辑仓库编码
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "发货逻辑仓库编码")
    private String deliveryPhysicsWarehouseCode;
    /**
     * 发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryPhysicsWarehouseName;
    /**
     * 收货物理仓库编码
     */
    @ApiModelProperty(name = "receivePhysicsWarehouseCode", value = "收货物理仓库编码")
    private String receivePhysicsWarehouseCode;
    /**
     * 收货物理仓库名称
     */
    @ApiModelProperty(name = "receivePhysicsWarehouseName", value = "收货物理仓库名称")
    private String receivePhysicsWarehouseName;

    /**
     * 发货结果单集合
     */
    @Deprecated
    @ApiModelProperty(name = "deliveryResultList", value = "发货结果单集合")
    private List<CsDeliveryResultOrderRespDto> deliveryResultList;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "contactDto", value = "前置单据冗余信息")
    private ContactDto contactDto;

    @ApiModelProperty(name = "deliveryNoticeOrderDetailRespDtoList", value = "发货货品详情")
    private List<CsDeliveryNoticeOrderDetailRespDto> deliveryNoticeOrderDetailRespDtoList;

    @Deprecated
    @ApiModelProperty(name = "resultNo", value = "结果单号")
    private List<String> resultNo;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "skuNum", value = "sku数量")
    private String skuNum;
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private String totalQuantity;
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private String mergeQuantity;
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList;
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;
    @ApiModelProperty(name = "orderType", value = "单据类型：delivery-发货通知单，receive-收货通知单")
    private String orderType;

    /** 出库物理仓库编码 */
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓库编码")
    private String outPhysicsWarehouseCode;
    /** 出库物理仓库名称 */
    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓库名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name="bizDate",value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getReceiveWarehouseId() {
        return receiveWarehouseId;
    }

    public void setReceiveWarehouseId(Long receiveWarehouseId) {
        this.receiveWarehouseId = receiveWarehouseId;
    }

    public String getReceiveWarehouseCode() {
        return receiveWarehouseCode;
    }

    public void setReceiveWarehouseCode(String receiveWarehouseCode) {
        this.receiveWarehouseCode = receiveWarehouseCode;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public String getReceiveWarehouseClassify() {
        return receiveWarehouseClassify;
    }

    public void setReceiveWarehouseClassify(String receiveWarehouseClassify) {
        this.receiveWarehouseClassify = receiveWarehouseClassify;
    }

    public String getDeliveryLogicWarehouseCode() {
        return deliveryLogicWarehouseCode;
    }

    public void setDeliveryLogicWarehouseCode(String deliveryLogicWarehouseCode) {
        this.deliveryLogicWarehouseCode = deliveryLogicWarehouseCode;
    }

    public String getDeliveryLogicWarehouseName() {
        return deliveryLogicWarehouseName;
    }

    public void setDeliveryLogicWarehouseName(String deliveryLogicWarehouseName) {
        this.deliveryLogicWarehouseName = deliveryLogicWarehouseName;
    }

    public String getReceiveLogicWarehouseCode() {
        return receiveLogicWarehouseCode;
    }

    public void setReceiveLogicWarehouseCode(String receiveLogicWarehouseCode) {
        this.receiveLogicWarehouseCode = receiveLogicWarehouseCode;
    }

    public String getReceiveLogicWarehouseName() {
        return receiveLogicWarehouseName;
    }

    public void setReceiveLogicWarehouseName(String receiveLogicWarehouseName) {
        this.receiveLogicWarehouseName = receiveLogicWarehouseName;
    }

    public String getDeliveryPhysicsWarehouseCode() {
        return deliveryPhysicsWarehouseCode;
    }

    public void setDeliveryPhysicsWarehouseCode(String deliveryPhysicsWarehouseCode) {
        this.deliveryPhysicsWarehouseCode = deliveryPhysicsWarehouseCode;
    }

    public String getDeliveryPhysicsWarehouseName() {
        return deliveryPhysicsWarehouseName;
    }

    public void setDeliveryPhysicsWarehouseName(String deliveryPhysicsWarehouseName) {
        this.deliveryPhysicsWarehouseName = deliveryPhysicsWarehouseName;
    }

    public String getReceivePhysicsWarehouseCode() {
        return receivePhysicsWarehouseCode;
    }

    public void setReceivePhysicsWarehouseCode(String receivePhysicsWarehouseCode) {
        this.receivePhysicsWarehouseCode = receivePhysicsWarehouseCode;
    }

    public String getReceivePhysicsWarehouseName() {
        return receivePhysicsWarehouseName;
    }

    public void setReceivePhysicsWarehouseName(String receivePhysicsWarehouseName) {
        this.receivePhysicsWarehouseName = receivePhysicsWarehouseName;
    }

    public String getTotalQuantity() {
        return totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public List<CsDeliveryNoticeOrderDetailRespDto> getDeliveryNoticeOrderDetailRespDtoList() {
        return deliveryNoticeOrderDetailRespDtoList;
    }

    public void setDeliveryNoticeOrderDetailRespDtoList(List<CsDeliveryNoticeOrderDetailRespDto> deliveryNoticeOrderDetailRespDtoList) {
        this.deliveryNoticeOrderDetailRespDtoList = deliveryNoticeOrderDetailRespDtoList;
    }

    public List<String> getResultNo() {
        return resultNo;
    }

    public void setResultNo(List<String> resultNo) {
        this.resultNo = resultNo;
    }

    public List<CsDeliveryResultOrderRespDto> getDeliveryResultList() {
        return deliveryResultList;
    }

    public void setDeliveryResultList(List<CsDeliveryResultOrderRespDto> deliveryResultList) {
        this.deliveryResultList = deliveryResultList;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public String getSkuNum() {
        return skuNum;
    }

    public void setSkuNum(String skuNum) {
        this.skuNum = skuNum;
    }

    public void setTotalQuantity(String totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(String mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public List<CsBasisOrderRelOrderInfoRespDto> getRelOrderInfoList() {
        return relOrderInfoList;
    }

    public void setRelOrderInfoList(List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        this.relOrderInfoList = relOrderInfoList;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOutPhysicsWarehouseCode() {
        return outPhysicsWarehouseCode;
    }

    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode) {
        this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }

    public String getOutPhysicsWarehouseName() {
        return outPhysicsWarehouseName;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }
}
