package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BaseDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @version 1.0
 * @Date 2022/5/17 2:16 下午
 */
public class CsDeliveryReceiveResultRespDto extends BaseDto implements Serializable {

    /** 发/收货通知单号 */
    @ApiModelProperty(name="documentNo",value = "发/收货通知单号")
    private String documentNo;
    /** wms单号（已废弃） */
    @ApiModelProperty(name="wmsNo",value = "wms单号（已废弃）")
    private String wmsNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 外部单号 */
    @ApiModelProperty(name="externalOrderNo",value = "外部单号")
    private String externalOrderNo;
    /** wms单号 */
    @ApiModelProperty(name="wmsOrderNo",value = "wms单号")
    private String wmsOrderNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;
    /** 业务单据表名 */
    @ApiModelProperty(name="relevanceTableName",value = "业务单据表名")
    private String relevanceTableName;
    /** 单据类型：delivery-发货结果单，receive-收货结果单 */
    @ApiModelProperty(name="orderType",value = "单据类型：delivery-发货结果单，receive-收货结果单")
    private String orderType;
    /** 单据状态,待定 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 店铺ID */
    @ApiModelProperty(name="shopId",value = "店铺ID")
    private Long shopId;
    /** 店铺编码 */
    @ApiModelProperty(name="shopCode",value = "店铺编码")
    private String shopCode;
    /** 店铺名称 */
    @ApiModelProperty(name="shopName",value = "店铺名称")
    private String shopName;
    /** 发货仓库ID（已废弃） */
    @ApiModelProperty(name="warehouseId",value = "发货仓库ID（已废弃）")
    private Long warehouseId;
    /** 发货仓库编码（已废弃） */
    @ApiModelProperty(name="warehouseCode",value = "发货仓库编码（已废弃）")
    private String warehouseCode;
    /** 发货仓库名称（已废弃） */
    @ApiModelProperty(name="warehouseName",value = "发货仓库名称（已废弃）")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓（已废弃） */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String warehouseClassify;
    /** 收货仓库ID（已废弃） */
    @ApiModelProperty(name="receiveWarehouseId",value = "收货仓库ID（已废弃）")
    private Long receiveWarehouseId;
    /** 收货仓库编码（已废弃） */
    @ApiModelProperty(name="receiveWarehouseCode",value = "收货仓库编码（已废弃）")
    private String receiveWarehouseCode;
    /** 收货仓库名称（已废弃） */
    @ApiModelProperty(name="receiveWarehouseName",value = "收货仓库名称（已废弃）")
    private String receiveWarehouseName;
    /** 收货仓库分类,physics-物理仓,logic-逻辑仓（已废弃） */
    @ApiModelProperty(name="receiveWarehouseClassify",value = "收货仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String receiveWarehouseClassify;
    /** 发货逻辑仓库编码 */
    @ApiModelProperty(name="deliveryLogicWarehouseCode",value = "发货逻辑仓库编码")
    private String deliveryLogicWarehouseCode;
    /** 发货逻辑仓库名称 */
    @ApiModelProperty(name="deliveryLogicWarehouseName",value = "发货逻辑仓库名称")
    private String deliveryLogicWarehouseName;
    /** 收货逻辑仓库编码 */
    @ApiModelProperty(name="receiveLogicWarehouseCode",value = "收货逻辑仓库编码")
    private String receiveLogicWarehouseCode;
    /** 收货逻辑仓库名称 */
    @ApiModelProperty(name="receiveLogicWarehouseName",value = "收货逻辑仓库名称")
    private String receiveLogicWarehouseName;
    /** 物理发货仓编码 */
    @ApiModelProperty(name="deliveryPhysicsWarehouseCode",value = "物理发货仓编码")
    private String deliveryPhysicsWarehouseCode;
    /** 物理发货仓名字 */
    @ApiModelProperty(name="deliveryPhysicsWarehouseName",value = "物理发货仓名字")
    private String deliveryPhysicsWarehouseName;
    /** 收货物理仓编码 */
    @ApiModelProperty(name="receivePhysicsWarehouseCode",value = "收货物理仓编码")
    private String receivePhysicsWarehouseCode;
    /** 收货物理仓名字 */
    @ApiModelProperty(name="receivePhysicsWarehouseName",value = "收货物理仓名字")
    private String receivePhysicsWarehouseName;
    /** 发货总数量 */
    @ApiModelProperty(name="totalQuantity",value = "发货总数量")
    private BigDecimal totalQuantity;
    /** 总箱数 */
    @ApiModelProperty(name="totalCartons",value = "总箱数")
    private BigDecimal totalCartons;
    /** 拼箱数 */
    @ApiModelProperty(name="mergeQuantity",value = "拼箱数")
    private BigDecimal mergeQuantity;
    /** 物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码) */
    @ApiModelProperty(name="shippingCompanyCode",value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;
    /** 物流公司名称 */
    @ApiModelProperty(name="shippingCompany",value = "物流公司名称")
    private String shippingCompany;
    /** 运输方式 */
    @ApiModelProperty(name="shippingType",value = "运输方式")
    private String shippingType;
    /** 物流公司运单号（存储母单号） */
    @ApiModelProperty(name="shippingCode",value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /** 物流信息JSON数据 */
    @ApiModelProperty(name="shippingJson",value = "物流信息JSON数据")
    private String shippingJson;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;
    /** 版本：0.迁移旧数据，1.一期迭代二，2.二期 */
    @ApiModelProperty(name="version",value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    /** 商品明细信息 */
    @ApiModelProperty(name="version",value = "商品明细信息")
    private List<CsDeliveryReceiveResultDetailRespDto> deliveryReceiveResultDetailRespDtoList;

    /**
     * 创建时间
     */
    private Date createTime;

    @ApiModelProperty(name="saleOrder",value = "对应的销售单信息")
    private BizSaleOrderRespDto saleOrder;

    public String getShippingJson() {
        return shippingJson;
    }

    public void setShippingJson(String shippingJson) {
        this.shippingJson = shippingJson;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getReceiveWarehouseId() {
        return receiveWarehouseId;
    }

    public void setReceiveWarehouseId(Long receiveWarehouseId) {
        this.receiveWarehouseId = receiveWarehouseId;
    }

    public String getReceiveWarehouseCode() {
        return receiveWarehouseCode;
    }

    public void setReceiveWarehouseCode(String receiveWarehouseCode) {
        this.receiveWarehouseCode = receiveWarehouseCode;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public String getReceiveWarehouseClassify() {
        return receiveWarehouseClassify;
    }

    public void setReceiveWarehouseClassify(String receiveWarehouseClassify) {
        this.receiveWarehouseClassify = receiveWarehouseClassify;
    }

    public String getDeliveryLogicWarehouseCode() {
        return deliveryLogicWarehouseCode;
    }

    public void setDeliveryLogicWarehouseCode(String deliveryLogicWarehouseCode) {
        this.deliveryLogicWarehouseCode = deliveryLogicWarehouseCode;
    }

    public String getDeliveryLogicWarehouseName() {
        return deliveryLogicWarehouseName;
    }

    public void setDeliveryLogicWarehouseName(String deliveryLogicWarehouseName) {
        this.deliveryLogicWarehouseName = deliveryLogicWarehouseName;
    }

    public String getReceiveLogicWarehouseCode() {
        return receiveLogicWarehouseCode;
    }

    public void setReceiveLogicWarehouseCode(String receiveLogicWarehouseCode) {
        this.receiveLogicWarehouseCode = receiveLogicWarehouseCode;
    }

    public String getReceiveLogicWarehouseName() {
        return receiveLogicWarehouseName;
    }

    public void setReceiveLogicWarehouseName(String receiveLogicWarehouseName) {
        this.receiveLogicWarehouseName = receiveLogicWarehouseName;
    }

    public String getDeliveryPhysicsWarehouseCode() {
        return deliveryPhysicsWarehouseCode;
    }

    public void setDeliveryPhysicsWarehouseCode(String deliveryPhysicsWarehouseCode) {
        this.deliveryPhysicsWarehouseCode = deliveryPhysicsWarehouseCode;
    }

    public String getDeliveryPhysicsWarehouseName() {
        return deliveryPhysicsWarehouseName;
    }

    public void setDeliveryPhysicsWarehouseName(String deliveryPhysicsWarehouseName) {
        this.deliveryPhysicsWarehouseName = deliveryPhysicsWarehouseName;
    }

    public String getReceivePhysicsWarehouseCode() {
        return receivePhysicsWarehouseCode;
    }

    public void setReceivePhysicsWarehouseCode(String receivePhysicsWarehouseCode) {
        this.receivePhysicsWarehouseCode = receivePhysicsWarehouseCode;
    }

    public String getReceivePhysicsWarehouseName() {
        return receivePhysicsWarehouseName;
    }

    public void setReceivePhysicsWarehouseName(String receivePhysicsWarehouseName) {
        this.receivePhysicsWarehouseName = receivePhysicsWarehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public List<CsDeliveryReceiveResultDetailRespDto> getDeliveryReceiveResultDetailRespDtoList() {
        return deliveryReceiveResultDetailRespDtoList;
    }

    public void setDeliveryReceiveResultDetailRespDtoList(List<CsDeliveryReceiveResultDetailRespDto> deliveryReceiveResultDetailRespDtoList) {
        this.deliveryReceiveResultDetailRespDtoList = deliveryReceiveResultDetailRespDtoList;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public BizSaleOrderRespDto getSaleOrder() {
        return saleOrder;
    }

    public void setSaleOrder(BizSaleOrderRespDto saleOrder) {
        this.saleOrder = saleOrder;
    }
}
