/**
 * @(#)CsDeliveryResultOrderDetailRespDto.java 1.0 2021/12/29 12:30
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

//
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* @Description CsDeliveryResultOrderDetailRespDto
*
* @author jingran
* @Date: 2021/12/29 12:30
* @since 1.0.0
*/
@ApiModel(value = "csDeliveryResultOrderDetailRespDto", description = "返回信息Dto")
public class CsDeliveryResultOrderDetailRespDto extends BaseRespDto {

    /** 发货结果单号 */
    @ApiModelProperty(name="documentNo",value = "发货结果单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号,为出库结果单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号,为出库结果单号")
    private String preOrderNo;

    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品长编码 */
    @ApiModelProperty(name="longCode",value = "货品长编码")
    private String longCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 发货数量 */
    @ApiModelProperty(name="quantity",value = "发货数量")
    private BigDecimal quantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /**
     * 活动ID，如果是活动商品的，必传，普通商品，不传
     */
    @ApiModelProperty(name="activityId",value = "活动ID，如果是活动商品的，必传，普通商品，不传")
    private Long activityId;

    @ApiModelProperty(name="tradeOrderItemId",value = "商品行明细id")
    private Long tradeOrderItemId;


    /**
     * 计划入库数量
     */
    @ApiModelProperty(name="planQuantity",value = "计划入库数量")
    private BigDecimal planQuantity;
    /**
     * 待入库数量
     */
    @ApiModelProperty(name="waitQuantity",value = "待入库数量")
    private BigDecimal waitQuantity;
    /**
     * 已入库数量
     */
    @ApiModelProperty(name="doneQuantity",value = "已入库数量")
    private BigDecimal doneQuantity;

    @ApiModelProperty(name="produceTime",value = "生产日期")
    private String produceTime;

    @ApiModelProperty(name="expireTime",value = "过期日期")
    private String expireTime;

    public String getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }


    public String getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(String produceTime) {
        this.produceTime = produceTime;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public BigDecimal getWaitQuantity() {
        return waitQuantity;
    }

    public void setWaitQuantity(BigDecimal waitQuantity) {
        this.waitQuantity = waitQuantity;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }


    public Long getTradeOrderItemId() {
        return tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }


    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }
}

