/**
 * @(#)CsDeliveryResultOrderRespDto.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

//

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
* 订单号查询已出库的拼箱数、总箱数信息
*
* @author jingran
* @Date: 2021/12/29 11:08
* @since 1.0.0
*/
@ApiModel(value = "CsDeliveryTotalCartonsRespDto", description = "订单号查询已出库的拼箱数、总箱数信息")
public class CsDeliveryTotalCartonsRespDto implements Serializable {

    /** 订单号 **/
    @ApiModelProperty(name="orderNo",value = "订单号")
    private String orderNo;

    /** 总箱数 **/
    @ApiModelProperty(name="totalCartons",value = "总箱数")
    private BigDecimal totalCartons;

    /** 拼箱数 **/
    @ApiModelProperty(name="mergeQuantity",value = "拼箱数")
    private BigDecimal mergeQuantity;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }
}
