/**
 * @(#)CsInNoticeOrderRespDto.java 1.0 2021/12/29 11:10
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description CsInNoticeOrderRespDto
 *
 * @author jingran
 * @Date: 2021/12/29 11:10
 * @since 1.0.0
 */
@ApiModel(value = "csInNoticeOrderRespDto", description = "返回信息Dto")
public class CsInNoticeOrderRespDto extends BaseRespDto {

    /** 入库通知单号 */
    @ApiModelProperty(name="documentNo",value = "入库通知单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 外部单号 */
    @ApiModelProperty(name="externalOrderNo",value = "外部单号")
    private String externalOrderNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;
    /** 入库结果单 */
    @ApiModelProperty(name="inResultNo",value = "出库结果单")
    private String inResultNo;
    /** 单据状态,待定 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 收货店铺ID */
    @ApiModelProperty(name="shopId",value = "收货店铺ID")
    private Long shopId;
    /** 收货店铺编码 */
    @ApiModelProperty(name="shopCode",value = "收货店铺编码")
    private String shopCode;
    /** 收货店铺名称 */
    @ApiModelProperty(name="shopName",value = "收货店铺名称")
    private String shopName;
    /** 收货仓库ID */
    @ApiModelProperty(name="warehouseId",value = "收货仓库ID")
    private Long warehouseId;
    /** 收货仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "收货仓库编码")
    private String warehouseCode;
    /** 收货仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "收货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 出库仓库ID */
    @ApiModelProperty(name = "outWarehouseId",value = "出库仓库ID")
    private Long outWarehouseId;
    /** 出库仓库编码 */
    @ApiModelProperty(name = "outWarehouseCode",value = "出库仓库编码")
    private String outWarehouseCode;
    /** 出库仓库名称 */
    @ApiModelProperty(name = "outWarehouseName",value = "出库仓库名称")
    private String outWarehouseName;
    /** 出库仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name = "outWarehouseClassify",value = "出库仓库分类,physics-物理仓,logic-逻辑仓")
    private String outWarehouseClassify;
    /** 入库逻辑仓库编码 */
    @ApiModelProperty(name = "inLogicWarehouseCode",value = "入库逻辑仓库编码")
    private String inLogicWarehouseCode;
    /** 入库逻辑仓库名称 */
    @ApiModelProperty(name = "inLogicWarehouseName",value = "入库逻辑仓库名称")
    private String inLogicWarehouseName;
    /** 出库仓库编码 */
    @ApiModelProperty(name = "outLogicWarehouseCode",value = "出库仓库编码")
    private String outLogicWarehouseCode;
    /** 出库仓库名称 */
    @ApiModelProperty(name = "outLogicWarehouseName",value = "出库仓库名称")
    private String outLogicWarehouseName;
    /** 关联单据信息 **/
    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList;
    /** 入库总数量 */
    @ApiModelProperty(name="totalQuantity",value = "入库总数量")
    private BigDecimal totalQuantity;
    /** 拼箱数 */
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /** 总箱数 */
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /** sku数量 */
    @ApiModelProperty(name = "skuNum", value = "sku数量")
    private BigDecimal skuNum;
    /** 前置单据冗余信息 */
    @ApiModelProperty(name = "contactDto", value = "前置单据冗余信息")
    private ContactDto contactDto;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 业务单据表名 */
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;
    /** 业务时间 */
    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getInResultNo() {
        return inResultNo;
    }

    public void setInResultNo(String inResultNo) {
        this.inResultNo = inResultNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getOutWarehouseId() {
        return outWarehouseId;
    }

    public void setOutWarehouseId(Long outWarehouseId) {
        this.outWarehouseId = outWarehouseId;
    }

    public String getOutWarehouseCode() {
        return outWarehouseCode;
    }

    public void setOutWarehouseCode(String outWarehouseCode) {
        this.outWarehouseCode = outWarehouseCode;
    }

    public String getOutWarehouseName() {
        return outWarehouseName;
    }

    public void setOutWarehouseName(String outWarehouseName) {
        this.outWarehouseName = outWarehouseName;
    }

    public String getOutWarehouseClassify() {
        return outWarehouseClassify;
    }

    public void setOutWarehouseClassify(String outWarehouseClassify) {
        this.outWarehouseClassify = outWarehouseClassify;
    }

    public String getInLogicWarehouseCode() {
        return inLogicWarehouseCode;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public String getOutLogicWarehouseCode() {
        return outLogicWarehouseCode;
    }

    public void setOutLogicWarehouseCode(String outLogicWarehouseCode) {
        this.outLogicWarehouseCode = outLogicWarehouseCode;
    }

    public String getOutLogicWarehouseName() {
        return outLogicWarehouseName;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public List<CsBasisOrderRelOrderInfoRespDto> getRelOrderInfoList() {
        return relOrderInfoList;
    }

    public void setRelOrderInfoList(List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        this.relOrderInfoList = relOrderInfoList;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getSkuNum() {
        return skuNum;
    }

    public void setSkuNum(BigDecimal skuNum) {
        this.skuNum = skuNum;
    }

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }
}
