package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 *
 * 出入库结果单生成后返回的DTO信息
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/5/17 2:10 下午
 */
public class CsInOutResultRespDto implements Serializable {

    /** 出/入货通知单号 */
    @ApiModelProperty(name="documentNo",value = "出/入货通知单号")
    private String documentNo;
    /** wms单号（已废弃） */
    @ApiModelProperty(name="wmsNo",value = "wms单号（已废弃）")
    private String wmsNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 外部单号 */
    @ApiModelProperty(name="externalOrderNo",value = "外部单号")
    private String externalOrderNo;
    /** WMS单号 */
    @ApiModelProperty(name="wmsOrderNo",value = "WMS单号")
    private String wmsOrderNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;
    /** 业务单据表名 */
    @ApiModelProperty(name="relevanceTableName",value = "业务单据表名")
    private String relevanceTableName;
    /** 单据类型：out-出库结果单，in-入库结果单 */
    @ApiModelProperty(name="orderType",value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;
    /** 单据状态,待定 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 店铺ID */
    @ApiModelProperty(name="shopId",value = "店铺ID")
    private Long shopId;
    /** 店铺编码 */
    @ApiModelProperty(name="shopCode",value = "店铺编码")
    private String shopCode;
    /** 店铺名称 */
    @ApiModelProperty(name="shopName",value = "店铺名称")
    private String shopName;
    /** 发货仓库ID（已废弃） */
    @ApiModelProperty(name="warehouseId",value = "发货仓库ID（已废弃）")
    private Long warehouseId;
    /** 发货仓库编码（已废弃） */
    @ApiModelProperty(name="warehouseCode",value = "发货仓库编码（已废弃）")
    private String warehouseCode;
    /** 发货仓库名称（已废弃） */
    @ApiModelProperty(name="warehouseName",value = "发货仓库名称（已废弃）")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓（已废弃） */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String warehouseClassify;
    /** 入库仓库ID（已废弃） */
    @ApiModelProperty(name="inWarehouseId",value = "入库仓库ID（已废弃）")
    private Long inWarehouseId;
    /** 入库仓库编码（已废弃） */
    @ApiModelProperty(name="inWarehouseCode",value = "入库仓库编码（已废弃）")
    private String inWarehouseCode;
    /** 入库仓库名称（已废弃） */
    @ApiModelProperty(name="inWarehouseName",value = "入库仓库名称（已废弃）")
    private String inWarehouseName;
    /** 入库仓库分类,physics-物理仓,logic-逻辑仓（已废弃） */
    @ApiModelProperty(name="inWarehouseClassify",value = "入库仓库分类,physics-物理仓,logic-逻辑仓（已废弃）")
    private String inWarehouseClassify;
    /** 出库逻辑仓库编码 */
    @ApiModelProperty(name="outPhysicsWarehouseCode",value = "出库逻辑仓库编码")
    private String outPhysicsWarehouseCode;
    /** 出库逻辑仓库名称 */
    @ApiModelProperty(name="outPhysicsWarehouseName",value = "出库逻辑仓库名称")
    private String outPhysicsWarehouseName;
    /** 入库逻辑仓库编码 */
    @ApiModelProperty(name="inPhysicsWarehouseCode",value = "入库逻辑仓库编码")
    private String inPhysicsWarehouseCode;
    /** 入库逻辑仓库名称 */
    @ApiModelProperty(name="inPhysicsWarehouseName",value = "入库逻辑仓库名称")
    private String inPhysicsWarehouseName;
    /** 出库逻辑仓库编码 */
    @ApiModelProperty(name="outLogicWarehouseCode",value = "出库逻辑仓库编码")
    private String outLogicWarehouseCode;
    /** 出库逻辑仓库名称 */
    @ApiModelProperty(name="outLogicWarehouseName",value = "出库逻辑仓库名称")
    private String outLogicWarehouseName;
    /** 入库逻辑仓库编码 */
    @ApiModelProperty(name="inLogicWarehouseCode",value = "入库逻辑仓库编码")
    private String inLogicWarehouseCode;
    /** 入库逻辑仓库名称 */
    @ApiModelProperty(name="inLogicWarehouseName",value = "入库逻辑仓库名称")
    private String inLogicWarehouseName;
    /** 出库总数量 */
    @ApiModelProperty(name="totalQuantity",value = "出库总数量")
    private BigDecimal totalQuantity;
    /** 总箱数 */
    @ApiModelProperty(name="totalCartons",value = "总箱数")
    private BigDecimal totalCartons;
    /** 拼箱数 */
    @ApiModelProperty(name="mergeQuantity",value = "拼箱数")
    private BigDecimal mergeQuantity;
    /** 物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码) */
    @ApiModelProperty(name="shippingCompanyCode",value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;
    /** 物流公司名称 */
    @ApiModelProperty(name="shippingCompany",value = "物流公司名称")
    private String shippingCompany;
    /** 物流公司运单号（存储母单号） */
    @ApiModelProperty(name="shippingCode",value = "物流公司运单号（存储母单号）")
    private String shippingCode;
    /** 运输方式 */
    @ApiModelProperty(name="shippingType",value = "运输方式")
    private String shippingType;
    /** 托运单号 */
    @ApiModelProperty(name="consignmentNo",value = "托运单号")
    private String consignmentNo;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织名称 */
    @ApiModelProperty(name="organizationName",value = "组织名称")
    private String organizationName;
    /** 版本：0.迁移旧数据，1.一期迭代二，2.二期 */
    @ApiModelProperty(name="version",value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    /** 商品明细信息 */
    @ApiModelProperty(name="inOutResultDetailRespDtoList",value = "商品明细信息")
    private List<CsInOutResultDetailRespDto> inOutResultDetailRespDtoList;

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public String getWmsOrderNo() {
        return wmsOrderNo;
    }

    public void setWmsOrderNo(String wmsOrderNo) {
        this.wmsOrderNo = wmsOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getInWarehouseId() {
        return inWarehouseId;
    }

    public void setInWarehouseId(Long inWarehouseId) {
        this.inWarehouseId = inWarehouseId;
    }

    public String getInWarehouseCode() {
        return inWarehouseCode;
    }

    public void setInWarehouseCode(String inWarehouseCode) {
        this.inWarehouseCode = inWarehouseCode;
    }

    public String getInWarehouseName() {
        return inWarehouseName;
    }

    public void setInWarehouseName(String inWarehouseName) {
        this.inWarehouseName = inWarehouseName;
    }

    public String getInWarehouseClassify() {
        return inWarehouseClassify;
    }

    public void setInWarehouseClassify(String inWarehouseClassify) {
        this.inWarehouseClassify = inWarehouseClassify;
    }

    public String getOutPhysicsWarehouseCode() {
        return outPhysicsWarehouseCode;
    }

    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode) {
        this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }

    public String getOutPhysicsWarehouseName() {
        return outPhysicsWarehouseName;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }

    public String getInPhysicsWarehouseCode() {
        return inPhysicsWarehouseCode;
    }

    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode) {
        this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }

    public String getInPhysicsWarehouseName() {
        return inPhysicsWarehouseName;
    }

    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName) {
        this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }

    public String getOutLogicWarehouseCode() {
        return outLogicWarehouseCode;
    }

    public void setOutLogicWarehouseCode(String outLogicWarehouseCode) {
        this.outLogicWarehouseCode = outLogicWarehouseCode;
    }

    public String getOutLogicWarehouseName() {
        return outLogicWarehouseName;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public String getInLogicWarehouseCode() {
        return inLogicWarehouseCode;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getConsignmentNo() {
        return consignmentNo;
    }

    public void setConsignmentNo(String consignmentNo) {
        this.consignmentNo = consignmentNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public List<CsInOutResultDetailRespDto> getInOutResultDetailRespDtoList() {
        return inOutResultDetailRespDtoList;
    }

    public void setInOutResultDetailRespDtoList(List<CsInOutResultDetailRespDto> inOutResultDetailRespDtoList) {
        this.inOutResultDetailRespDtoList = inOutResultDetailRespDtoList;
    }
}


