/**
 * @(#)CsInResultOrderDetailRespDto.java 1.0 2021/12/29 11:11
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
* @Description CsInResultOrderDetailRespDto
*
* @author jingran
* @Date: 2021/12/29 11:11
* @since 1.0.0
*/
@ApiModel(value = "csInResultOrderDetailRespDto", description = "返回信息Dto")
public class CsInResultOrderDetailRespDto implements Serializable {

    /** ID */
    @ApiModelProperty(name="id",value = "ID")
    private Long id;
    /** 入库结果单号 */
    @ApiModelProperty(name="documentNo",value = "入库结果单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;

    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 入库数量 */
    @ApiModelProperty(name="quantity",value = "入库数量")
    private BigDecimal quantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    /** 货品长编码 */
    @ApiModelProperty(name="longCode",value = "货品长编码")
    private String longCode;

    /** 原始计划入库数量 */
    @ApiModelProperty(name="originPlanQuantity",value = "原始计划入库数量")
    private BigDecimal originPlanQuantity;
    /**
     * 计划入库数量
     */
    @ApiModelProperty(name="planQuantity",value = "计划入库数量")
    private BigDecimal planQuantity;
    /**
     * 待入库数量
     */
    @ApiModelProperty(name="waitQuantity",value = "待入库数量")
    private BigDecimal waitQuantity;
    /**
     * 已入库数量
     */
    @ApiModelProperty(name="doneQuantity",value = "已入库数量")
    private BigDecimal doneQuantity;
    /**
     * 取消数量
     */
    @ApiModelProperty(name="cancelQuantity",value = "取消数量")
    private BigDecimal cancelQuantity;

    /**
     * 商品行状态
     */
    @ApiModelProperty(name="itemStatus",value = "商品行状态")
    private String itemStatus;

    @ApiModelProperty(name="detailRespDtoList",value = "多批次明细")
    private List<CsInResultOrderDetailRespDto> detailRespDtoList;

    @ApiModelProperty(name="produceTime",value = "生产日期")
    private String produceTime;

    @ApiModelProperty(name="expireTime",value = "过期日期")
    private String expireTime;

    public List<CsInResultOrderDetailRespDto> getDetailRespDtoList() {
        return detailRespDtoList;
    }

    public void setDetailRespDtoList(List<CsInResultOrderDetailRespDto> detailRespDtoList) {
        this.detailRespDtoList = detailRespDtoList;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }


    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public BigDecimal getOriginPlanQuantity() {
        return originPlanQuantity;
    }

    public void setOriginPlanQuantity(BigDecimal originPlanQuantity) {
        this.originPlanQuantity = originPlanQuantity;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public BigDecimal getWaitQuantity() {
        return waitQuantity;
    }

    public void setWaitQuantity(BigDecimal waitQuantity) {
        this.waitQuantity = waitQuantity;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public BigDecimal getCancelQuantity() {
        return cancelQuantity;
    }

    public void setCancelQuantity(BigDecimal cancelQuantity) {
        this.cancelQuantity = cancelQuantity;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(String produceTime) {
        this.produceTime = produceTime;
    }

    public String getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }
}
