/**
 * @(#)CsOutNoticeOrderDetailRespDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jingran
 * @Description CsOutNoticeOrderDetailRespDto
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@ApiModel(value = "csOutNoticeOrderDetailBatchRespDto", description = "返回信息Dto")
public class CsOutNoticeOrderDetailBatchRespDto extends BaseRespDto {
    /**
     * 货品名称
     **/
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 已出/入库数量
     **/
    @ApiModelProperty(name = "doneQuantity", value = "已出/入库数量")
    private BigDecimal doneQuantity;
    /**
     * 货品长编码
     **/
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;

    /** 商品行状态：正常-common，超收-overcharge，超收已解挂-relieve，异常-error */
    @ApiModelProperty(name = "itemStatus", value = "商品行状态：正常-common，超收-overcharge，超收已解挂-relieve，异常-error")
    private String itemStatus;

    /**
     * 出入库结果单关联单号
     **/
    @ApiModelProperty(name = "inOutResultOrderNo", value = "出入库结果单关联单号")
    private String inOutResultOrderNo;



    /**
     *生产日期
     */
    @ApiModelProperty(name = "expireTime", value = "生产日期")
    private Date produceTime;

    /**
     *过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public String getInOutResultOrderNo() {
        return inOutResultOrderNo;
    }

    public void setInOutResultOrderNo(String inOutResultOrderNo) {
        this.inOutResultOrderNo = inOutResultOrderNo;
    }
}
