/**
 * @(#)CsOutNoticeOrderDetailRespDto.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutNoticeOrderDetailRespDto
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@ApiModel(value = "csOutNoticeOrderDetailRespDto", description = "返回信息Dto")
public class CsOutNoticeOrderDetailRespDto extends BaseRespDto {
    /**
     * 出库通知单号
     **/
    @ApiModelProperty(name = "documentNo", value = "出库通知单号")
    private String documentNo;
    /**
     * 关联单据号
     **/
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     * 前置单号
     **/
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 货品ID
     **/
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 货品编码
     **/
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 商品长编码
     **/
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 货品名称
     **/
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 批次
     **/
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 计划出/入库数量
     **/
    @ApiModelProperty(name = "planQuantity", value = "计划出/入库数量")
    private BigDecimal planQuantity;
    /**
     * 待出/入库数量
     **/
    @ApiModelProperty(name = "waitQuantity", value = "待出/入库数量")
    private BigDecimal waitQuantity;
    /**
     * 已出/入库数量
     **/
    @ApiModelProperty(name = "doneQuantity", value = "已出/入库数量")
    private BigDecimal doneQuantity;
    /**
     * 取消总数量
     **/
    @ApiModelProperty(name = "cancelQuantity", value = "取消总数量")
    private BigDecimal cancelQuantity;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 规格
     */
    @ApiModelProperty(name = "specification", value = "规格")
    private String specification;
    /**
     * 体积
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    /**
     * 批次详情信息
     */
    @ApiModelProperty(name = "detailBatchRespDtoList", value = "批次详情信息")
    private List<CsOutNoticeOrderDetailBatchRespDto> detailBatchRespDtoList;

    /** 商品行状态：正常-common，超收-overcharge，超收已解挂-relieve，异常-error */
    @ApiModelProperty(name = "itemStatus", value = "商品行状态：正常-common，超收-overcharge，超收已解挂-relieve，异常-error")
    private String itemStatus;

    /**
     * 是否为初始化批次 1-是 0-否
     */
    @ApiModelProperty(name = "initFlag", value = "是否为初始化批次 1-是 0-否")
    private Integer initFlag;

    /**
     *生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产时间")
    private String produceTime;

    /**
     *过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private String expireTime;

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }


    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public BigDecimal getWaitQuantity() {
        return waitQuantity;
    }

    public void setWaitQuantity(BigDecimal waitQuantity) {
        this.waitQuantity = waitQuantity;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public BigDecimal getCancelQuantity() {
        return cancelQuantity;
    }

    public void setCancelQuantity(BigDecimal cancelQuantity) {
        this.cancelQuantity = cancelQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public List<CsOutNoticeOrderDetailBatchRespDto> getDetailBatchRespDtoList() {
        return detailBatchRespDtoList;
    }

    public void setDetailBatchRespDtoList(List<CsOutNoticeOrderDetailBatchRespDto> detailBatchRespDtoList) {
        this.detailBatchRespDtoList = detailBatchRespDtoList;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Integer getInitFlag() {
        return initFlag;
    }

    public void setInitFlag(Integer initFlag) {
        this.initFlag = initFlag;
    }

    public String getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(String produceTime) {
        this.produceTime = produceTime;
    }

    public String getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }
}
