/**
 * @(#)CsOutResultOrderRespDto.java 1.0 2021/12/29 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutResultOrderRespDto
 * @Date: 2021/12/29 11:13
 * @since 1.0.0
 */
@ApiModel(value = "csOutResultOrderRespDto", description = "返回信息Dto")
public class CsOutResultOrderRespDto extends BaseRespDto {

    /**
     * 出库结果单号
     */
    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;
    /**
     * 发、收货结果单
     */
    @ApiModelProperty(name = "deliveryResultOrderNo", value = "发、收货结果单")
    private String deliveryResultOrderNo;
    /**
     * wms单号，已废弃
     */
    @Deprecated
    @ApiModelProperty(name = "wmsNo", value = "wms单号，已废弃")
    private String wmsNo;
    /**
     * 关联单据号
     */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
     * 外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     * 前置单号
     */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    /**
     * 单据状态,待定
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;
    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     * 仓库ID
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库编码
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库分类,physics-物理仓,logic-逻辑仓
     */
    @Deprecated
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /**
     * 入库仓库ID
     */
    @Deprecated
    @ApiModelProperty(name = "inWarehouseId", value = "入库仓库ID")
    private Long inWarehouseId;
    /**
     * 入库仓库编码
     */
    @Deprecated
    @ApiModelProperty(name = "inWarehouseCode", value = "入库仓库编码")
    private String inWarehouseCode;
    /**
     * 入库仓库名称
     */
    @Deprecated
    @ApiModelProperty(name = "inWarehouseName", value = "入库仓库名称")
    private String inWarehouseName;
    /**
     * 入库仓库分类,physics-物理仓,logic-逻辑仓
     */
    @Deprecated
    @ApiModelProperty(name = "inWarehouseClassify", value = "入库仓库分类,physics-物理仓,logic-逻辑仓")
    private String inWarehouseClassify;
    /**
     * 入库物理仓库编码
     */
    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "入库物理仓库编码")
    private String inPhysicsWarehouseCode;
    /**
     * 入库物理仓库名称
     */
    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "入库物理仓库名称")
    private String inPhysicsWarehouseName;
    /**
     * 出库物理仓库编码
     */
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓库编码")
    private String outPhysicsWarehouseCode;
    /**
     * 出库物理仓库名称
     */
    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓库名称")
    private String outPhysicsWarehouseName;
    /**
     * 入库逻辑仓库编码
     */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓库编码")
    private String inLogicWarehouseCode;
    /**
     * 入库逻辑仓库名称
     */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓库名称")
    private String inLogicWarehouseName;
    /**
     * 出库逻辑仓库编码
     */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库逻辑仓库编码")
    private String outLogicWarehouseCode;
    /**
     * 出库逻辑仓库名称
     */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库逻辑仓库名称")
    private String outLogicWarehouseName;
    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
     * 拼箱数量
     */
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数量")
    private BigDecimal mergeQuantity;
    /**
     * 总箱数
     */
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /**
     * sku数量
     */
    @ApiModelProperty(name = "skuNum", value = "sku数量")
    private BigDecimal skuNum;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 物流公司编码
     */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码")
    private String shippingCompanyCode;
    /**
     * 物流公司
     */
    @ApiModelProperty(name = "shippingCompany", value = "物流公司")
    private String shippingCompany;
    /**
     * 物流单号
     */
    @ApiModelProperty(name = "shippingCode", value = "物流单号")
    private String shippingCode;
    /**
     * 发货方式
     */
    @ApiModelProperty(name = "shippingType", value = "发货方式")
    private String shippingType;
    @ApiModelProperty(name = "contactDto", value = "前置单据冗余信息")
    private ContactDto contactDto;

    @ApiModelProperty(name = "detailRespDtoList", value = "出库货品详情")
    private List<CsOutResultOrderDetailRespDto> detailRespDtoList;
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList;
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;
    @ApiModelProperty(name = "orderType", value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;

    @ApiModelProperty(name = "stringValidResult", value = "串码校验结果")
    private String stringValidResult;

    /**
     * 总重量
     */
    @ApiModelProperty(name = "totalWeight", value = "总重量")
    private BigDecimal totalWeight;

    /**
     * 总体积
     */
    @ApiModelProperty(name = "totalVolume", value = "总体积")
    private BigDecimal totalVolume;

    /** 业务时间 */
    @ApiModelProperty(name="bizDate",value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public BigDecimal getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public BigDecimal getTotalVolume() {
        return totalVolume;
    }

    public void setTotalVolume(BigDecimal totalVolume) {
        this.totalVolume = totalVolume;
    }

    public String getStringValidResult() {
        return stringValidResult;
    }

    public void setStringValidResult(String stringValidResult) {
        this.stringValidResult = stringValidResult;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingCode() {
        return shippingCode;
    }

    public void setShippingCode(String shippingCode) {
        this.shippingCode = shippingCode;
    }

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public List<CsOutResultOrderDetailRespDto> getDetailRespDtoList() {
        return detailRespDtoList;
    }

    public void setDetailRespDtoList(List<CsOutResultOrderDetailRespDto> detailRespDtoList) {
        this.detailRespDtoList = detailRespDtoList;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getInWarehouseId() {
        return inWarehouseId;
    }

    public void setInWarehouseId(Long inWarehouseId) {
        this.inWarehouseId = inWarehouseId;
    }

    public String getInWarehouseCode() {
        return inWarehouseCode;
    }

    public void setInWarehouseCode(String inWarehouseCode) {
        this.inWarehouseCode = inWarehouseCode;
    }

    public String getInWarehouseName() {
        return inWarehouseName;
    }

    public void setInWarehouseName(String inWarehouseName) {
        this.inWarehouseName = inWarehouseName;
    }

    public String getInWarehouseClassify() {
        return inWarehouseClassify;
    }

    public void setInWarehouseClassify(String inWarehouseClassify) {
        this.inWarehouseClassify = inWarehouseClassify;
    }

    public String getInPhysicsWarehouseCode() {
        return inPhysicsWarehouseCode;
    }

    public void setInPhysicsWarehouseCode(String inPhysicsWarehouseCode) {
        this.inPhysicsWarehouseCode = inPhysicsWarehouseCode;
    }

    public String getInPhysicsWarehouseName() {
        return inPhysicsWarehouseName;
    }

    public void setInPhysicsWarehouseName(String inPhysicsWarehouseName) {
        this.inPhysicsWarehouseName = inPhysicsWarehouseName;
    }

    public String getOutPhysicsWarehouseCode() {
        return outPhysicsWarehouseCode;
    }

    public void setOutPhysicsWarehouseCode(String outPhysicsWarehouseCode) {
        this.outPhysicsWarehouseCode = outPhysicsWarehouseCode;
    }

    public String getOutPhysicsWarehouseName() {
        return outPhysicsWarehouseName;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }

    public String getInLogicWarehouseCode() {
        return inLogicWarehouseCode;
    }

    public void setInLogicWarehouseCode(String inLogicWarehouseCode) {
        this.inLogicWarehouseCode = inLogicWarehouseCode;
    }

    public String getInLogicWarehouseName() {
        return inLogicWarehouseName;
    }

    public void setInLogicWarehouseName(String inLogicWarehouseName) {
        this.inLogicWarehouseName = inLogicWarehouseName;
    }

    public String getOutLogicWarehouseCode() {
        return outLogicWarehouseCode;
    }

    public void setOutLogicWarehouseCode(String outLogicWarehouseCode) {
        this.outLogicWarehouseCode = outLogicWarehouseCode;
    }

    public String getOutLogicWarehouseName() {
        return outLogicWarehouseName;
    }

    public void setOutLogicWarehouseName(String outLogicWarehouseName) {
        this.outLogicWarehouseName = outLogicWarehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getWmsNo() {
        return wmsNo;
    }

    public void setWmsNo(String wmsNo) {
        this.wmsNo = wmsNo;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getSkuNum() {
        return skuNum;
    }

    public void setSkuNum(BigDecimal skuNum) {
        this.skuNum = skuNum;
    }

    public String getDeliveryResultOrderNo() {
        return deliveryResultOrderNo;
    }

    public void setDeliveryResultOrderNo(String deliveryResultOrderNo) {
        this.deliveryResultOrderNo = deliveryResultOrderNo;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }

    public List<CsBasisOrderRelOrderInfoRespDto> getRelOrderInfoList() {
        return relOrderInfoList;
    }

    public void setRelOrderInfoList(List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        this.relOrderInfoList = relOrderInfoList;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
}
