/**
 * @(#)CsReceiveResultOrderRespDto.java 1.0 2021/12/29 11:16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order;

//
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* @Description CsReceiveResultOrderRespDto
*
* @author jingran
* @Date: 2021/12/29 11:16
* @since 1.0.0
*/
@ApiModel(value = "csReceiveResultOrderRespDto", description = "返回信息Dto")
public class CsReceiveResultOrderRespDto extends BaseRespDto {

    /** 收货结果单号 */
    @ApiModelProperty(name="documentNo",value = "收货结果单号")
    private String documentNo;
    /** 关联单据号 */
    @ApiModelProperty(name="relevanceNo",value = "关联单据号")
    private String relevanceNo;
    /** 前置单号 */
    @ApiModelProperty(name="preOrderNo",value = "前置单号")
    private String preOrderNo;
    /** 业务类型 */
    @ApiModelProperty(name="businessType",value = "业务类型")
    private String businessType;

    /** 单据状态,待定 */
    @ApiModelProperty(name="orderStatus",value = "单据状态,待定")
    private String orderStatus;
    /** 收货店铺ID */
    @ApiModelProperty(name="shopId",value = "收货店铺ID")
    private Long shopId;
    /** 收货店铺编码 */
    @ApiModelProperty(name="shopCode",value = "收货店铺编码")
    private String shopCode;
    /** 收货店铺名称 */
    @ApiModelProperty(name="shopName",value = "收货店铺名称")
    private String shopName;
    /** 收货仓库ID */
    @ApiModelProperty(name="warehouseId",value = "收货仓库ID")
    private Long warehouseId;
    /** 收货仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "收货仓库编码")
    private String warehouseCode;
    /** 收货仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "收货仓库名称")
    private String warehouseName;
    /** 仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类,physics-物理仓,logic-逻辑仓")
    private String warehouseClassify;
    /** 发货仓库ID */
    @ApiModelProperty(name = "deliveryWarehouseId", value = "发货仓库ID")
    private Long deliveryWarehouseId;
    /** 发货仓库编码 */
    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货仓库编码")
    private String deliveryWarehouseCode;
    /** 发货仓库名称 */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货仓库名称")
    private String deliveryWarehouseName;
    /** 发货仓库分类,physics-物理仓,logic-逻辑仓 */
    @ApiModelProperty(name = "deliveryWarehouseClassify", value = "发货仓库分类,physics-物理仓,logic-逻辑仓")
    private String deliveryWarehouseClassify;
    /** 收货物理仓库编码 */
    @ApiModelProperty(name = "receivePhysicsWarehouseCode", value = "收货物理仓库编码")
    private String receivePhysicsWarehouseCode;
    /** 收货物理仓库名称 */
    @ApiModelProperty(name = "receivePhysicsWarehouseName", value = "收货物理仓库名称")
    private String receivePhysicsWarehouseName;
    /** 发货物理仓库编码 */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseCode", value = "发货物理仓库编码")
    private String deliveryPhysicsWarehouseCode;
    /** 发货物理仓库名称 */
    @ApiModelProperty(name = "deliveryPhysicsWarehouseName", value = "发货物理仓库名称")
    private String deliveryPhysicsWarehouseName;
    /** 收货总数量 */
    @ApiModelProperty(name="totalQuantity",value = "收货总数量")
    private BigDecimal totalQuantity;
    /** 拼箱数 */
    @ApiModelProperty(name = "mergeQuantity", value = "拼箱数")
    private BigDecimal mergeQuantity;
    /** 总箱数 */
    @ApiModelProperty(name = "totalCartons", value = "总箱数")
    private BigDecimal totalCartons;
    /** sku数量 */
    @ApiModelProperty(name = "skuNum", value = "sku数量")
    private BigDecimal skuNum;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "contactDto", value = "前置单据冗余信息")
    private ContactDto contactDto;

    @ApiModelProperty(name = "receiveResultOrderDetailRespDtoList", value = "收货货品详情")
    private List<CsReceiveResultOrderDetailRespDto> receiveResultOrderDetailRespDtoList;

    @ApiModelProperty(name = "noticeNo", value = "通知单号")
    private List<String> noticeNo;

    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList;

    /** 业务单据表名 */
    @ApiModelProperty(name = "relevanceTableName", value = "业务单据表名")
    private String relevanceTableName;

    /** 外部单号 */
    @ApiModelProperty(name="externalOrderNo",value = "外部单号")
    private String externalOrderNo;

    @ApiModelProperty(name="bizDate",value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public List<String> getNoticeNo() {
        return noticeNo;
    }

    public void setNoticeNo(List<String> noticeNo) {
        this.noticeNo = noticeNo;
    }

    public ContactDto getContactDto() {
        return contactDto;
    }

    public void setContactDto(ContactDto contactDto) {
        this.contactDto = contactDto;
    }

    public List<CsReceiveResultOrderDetailRespDto> getReceiveResultOrderDetailRespDtoList() {
        return receiveResultOrderDetailRespDtoList;
    }

    public void setReceiveResultOrderDetailRespDtoList(List<CsReceiveResultOrderDetailRespDto> receiveResultOrderDetailRespDtoList) {
        this.receiveResultOrderDetailRespDtoList = receiveResultOrderDetailRespDtoList;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getRelevanceNo() {
        return relevanceNo;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getPreOrderNo() {
        return preOrderNo;
    }

    public void setPreOrderNo(String preOrderNo) {
        this.preOrderNo = preOrderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public Long getDeliveryWarehouseId() {
        return deliveryWarehouseId;
    }

    public void setDeliveryWarehouseId(Long deliveryWarehouseId) {
        this.deliveryWarehouseId = deliveryWarehouseId;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public String getDeliveryWarehouseClassify() {
        return deliveryWarehouseClassify;
    }

    public void setDeliveryWarehouseClassify(String deliveryWarehouseClassify) {
        this.deliveryWarehouseClassify = deliveryWarehouseClassify;
    }

    public String getReceivePhysicsWarehouseCode() {
        return receivePhysicsWarehouseCode;
    }

    public void setReceivePhysicsWarehouseCode(String receivePhysicsWarehouseCode) {
        this.receivePhysicsWarehouseCode = receivePhysicsWarehouseCode;
    }

    public String getReceivePhysicsWarehouseName() {
        return receivePhysicsWarehouseName;
    }

    public void setReceivePhysicsWarehouseName(String receivePhysicsWarehouseName) {
        this.receivePhysicsWarehouseName = receivePhysicsWarehouseName;
    }

    public String getDeliveryPhysicsWarehouseCode() {
        return deliveryPhysicsWarehouseCode;
    }

    public void setDeliveryPhysicsWarehouseCode(String deliveryPhysicsWarehouseCode) {
        this.deliveryPhysicsWarehouseCode = deliveryPhysicsWarehouseCode;
    }

    public String getDeliveryPhysicsWarehouseName() {
        return deliveryPhysicsWarehouseName;
    }

    public void setDeliveryPhysicsWarehouseName(String deliveryPhysicsWarehouseName) {
        this.deliveryPhysicsWarehouseName = deliveryPhysicsWarehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public BigDecimal getMergeQuantity() {
        return mergeQuantity;
    }

    public void setMergeQuantity(BigDecimal mergeQuantity) {
        this.mergeQuantity = mergeQuantity;
    }

    public BigDecimal getTotalCartons() {
        return totalCartons;
    }

    public void setTotalCartons(BigDecimal totalCartons) {
        this.totalCartons = totalCartons;
    }

    public BigDecimal getSkuNum() {
        return skuNum;
    }

    public void setSkuNum(BigDecimal skuNum) {
        this.skuNum = skuNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<CsBasisOrderRelOrderInfoRespDto> getRelOrderInfoList() {
        return relOrderInfoList;
    }

    public void setRelOrderInfoList(List<CsBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        this.relOrderInfoList = relOrderInfoList;
    }

    public String getRelevanceTableName() {
        return relevanceTableName;
    }

    public void setRelevanceTableName(String relevanceTableName) {
        this.relevanceTableName = relevanceTableName;
    }

    public String getExternalOrderNo() {
        return externalOrderNo;
    }

    public void setExternalOrderNo(String externalOrderNo) {
        this.externalOrderNo = externalOrderNo;
    }
}
