package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics;

import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 入、出库基础参数明细
 *
 * @author jinger
 * @version 1.0
 */
public class CsInOutBasicsOrderDetailRespDto implements Serializable {

    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    @ApiModelProperty(name = "balance", value = "即时库存")
    private BigDecimal balance;
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    @ApiModelProperty(name = "futureIn", value = "待收库存")
    private BigDecimal futureIn;
    @ApiModelProperty(name = "transfer", value = "在途库存")
    private BigDecimal intransit;

    @ApiModelProperty(name = "inNum", value = "入库数量中间状态值（例如调拨单的在途数量，生产单的待入数量）")
    private BigDecimal inNum;

    @ApiModelProperty(name = "tradeOrderItemId")
    private Long tradeOrderItemId;

    /**
     * 生产日期
     **/
    @ApiModelProperty(name = "expireTime", value = "生产日期")
    private Date expireTime;
    /**
     * 过期日期
     **/
    @ApiModelProperty(name = "produceTime", value = "过期日期")
    private Date produceTime;

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getFutureIn() {
        return futureIn;
    }

    public void setFutureIn(BigDecimal futureIn) {
        this.futureIn = futureIn;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getInNum() {
        return inNum;
    }

    public void setInNum(BigDecimal inNum) {
        this.inNum = inNum;
    }

    public Long getTradeOrderItemId() {
        return tradeOrderItemId;
    }

    public void setTradeOrderItemId(Long tradeOrderItemId) {
        this.tradeOrderItemId = tradeOrderItemId;
    }
}
