/**
 * @(#)CsInPlannedOrderRespDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jingran
 * @Description CsInPlannedOrderDetailQueryInfoRespDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 */
@ApiModel(value = "csInPlannedOrderRelOrderInfoRespDto", description = "关联单据信息DTO")
public class CsInPlannedOrderRelOrderInfoRespDto extends BaseRespDto {

    /**
     * ID
     **/
    @ApiModelProperty(name = "id", value = "ID")
    private Long id;
    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据号,系统生成的计划类单据号
     **/
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /**
     * 单据状态
     **/
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
     * 基础单据号
     **/
    @ApiModelProperty(name = "documentNo", value = "基础单据号")
    private String documentNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
     * 基础单据状态
     **/
    @ApiModelProperty(name = "documentOrderStatus", value = "基础单据状态")
    private String documentOrderStatus;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getDocumentOrderStatus() {
        return documentOrderStatus;
    }

    public void setDocumentOrderStatus(String documentOrderStatus) {
        this.documentOrderStatus = documentOrderStatus;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }
}
