/**
 * @(#)CsInPlannedOrderRespDto.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsStorageAuditRecordRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRelOrderInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsPlannedOrderAuditRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author jingran
 * @Description CsOutPlannedOrderDetailQueryInfoRespDto
 * @Date: 2022/04/13 15:39
 * @since 1.0.0
 */
@ApiModel(value = "CsOutPlannedOrderDetailQueryInfoRespDto", description = "单据详情信息DTO")
public class CsOutPlannedOrderDetailQueryInfoRespDto extends BaseRespDto {

    /**
     * 平台单号(来源于第三方系统)
     **/
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据号,系统生成的计划类单据号
     **/
    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     **/
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
     * 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起
     **/
    @ApiModelProperty(name = "orderStatus", value = "单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起")
    private String orderStatus;
    /**
     * 收货仓库ID
     **/
    @ApiModelProperty(name = "receiveWarehouseId", value = "收货仓库ID")
    private Long deliveryWarehouseId;
    /**
     * 收货仓库编码
     **/
    @ApiModelProperty(name = "receiveWarehouseCode", value = "收货仓库编码")
    private String deliveryWarehouseCode;
    /**
     * 收货仓库名称
     **/
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称")
    private String deliveryWarehouseName;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 供应商ID
     **/
    @ApiModelProperty(name = "supplierId", value = "供应商ID")
    private Long supplierId;
    /**
     * 供应商编码
     **/
    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     **/
    @ApiModelProperty(name = "supplierName", value = "供应商名称")
    private String supplierName;
    /**
     * 关联单据信息
     **/
    @ApiModelProperty(name = "relOrderInfoList", value = "关联单据信息")
    private List<CsOutPlannedOrderRelOrderInfoRespDto> relOrderInfoList;
    /**
     * 商品明细信息
     **/
    @ApiModelProperty(name = "itemInfoList", value = "商品明细信息")
    private List<CsOutPlannedOrderDetailRespDto> itemInfoList;
    /**
     * 审核信息
     **/
    @ApiModelProperty(name = "itemInfoList", value = "审核信息")
    private List<CsStorageAuditRecordRespDto> auditRespDtoList;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    public Date getBizDate() {
        return bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getDeliveryWarehouseId() {
        return deliveryWarehouseId;
    }

    public void setDeliveryWarehouseId(Long deliveryWarehouseId) {
        this.deliveryWarehouseId = deliveryWarehouseId;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public List<CsOutPlannedOrderRelOrderInfoRespDto> getRelOrderInfoList() {
        return relOrderInfoList;
    }

    public void setRelOrderInfoList(List<CsOutPlannedOrderRelOrderInfoRespDto> relOrderInfoList) {
        this.relOrderInfoList = relOrderInfoList;
    }

    public List<CsOutPlannedOrderDetailRespDto> getItemInfoList() {
        return itemInfoList;
    }

    public void setItemInfoList(List<CsOutPlannedOrderDetailRespDto> itemInfoList) {
        this.itemInfoList = itemInfoList;
    }

    public List<CsStorageAuditRecordRespDto> getAuditRespDtoList() {
        return auditRespDtoList;
    }

    public void setAuditRespDtoList(List<CsStorageAuditRecordRespDto> auditRespDtoList) {
        this.auditRespDtoList = auditRespDtoList;
    }
}
