/**
 * @(#)CsOutPlannedOrderDetailRespDto.java 1.0 2022/04/13 16:40
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsOutPlannedOrderDetailRespDto
*
* @author jingran
* @Date: 2022/04/13 16:40
* @since 1.0.0
*/
@ApiModel(value = "csOutPlannedOrderDetailRespDto", description = "返回信息Dto")
public class CsOutPlannedOrderDetailRespDto extends BaseRespDto {

    /** 平台单号(来源于第三方系统) */
    @ApiModelProperty(name="platformOrderNo",value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /** 单据号,系统生成的计划类单据号 */
    @ApiModelProperty(name="orderNo",value = "单据号,系统生成的计划类单据号")
    private String orderNo;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 计划数量 */
    @ApiModelProperty(name="planQuantity",value = "计划数量")
    private BigDecimal planQuantity;
    /** 待出库数量 */
    @ApiModelProperty(name="waitQuantity",value = "待出库数量")
    private BigDecimal waitQuantity;
    /** 已出库数量 */
    @ApiModelProperty(name="doneQuantity",value = "已出库数量")
    private BigDecimal doneQuantity;
    /** 取消数量 */
    @ApiModelProperty(name="cancelQuantity",value = "取消数量")
    private BigDecimal cancelQuantity;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 商品行状态：正常-common，数量异常-difference，异常已解挂-relieve，异常-error */
    @ApiModelProperty(name="itemStatus",value = "商品行状态：正常-common，数量异常-difference，异常已解挂-relieve，异常-error")
    private String itemStatus;
    /** 差异数量 */
    @ApiModelProperty(name="differenceQuantity",value = "差异数量")
    private BigDecimal differenceQuantity;
    /** 过期日期 */
    @ApiModelProperty(name="expireTime",value = "过期日期")
    private Date expireTime;
    /** 生产日期 */
    @ApiModelProperty(name="produceTime",value = "生产日期")
    private Date produceTime;

    public String getPlatformOrderNo() {
        return platformOrderNo;
    }

    public void setPlatformOrderNo(String platformOrderNo) {
        this.platformOrderNo = platformOrderNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getPlanQuantity() {
        return planQuantity;
    }

    public void setPlanQuantity(BigDecimal planQuantity) {
        this.planQuantity = planQuantity;
    }

    public BigDecimal getWaitQuantity() {
        return waitQuantity;
    }

    public void setWaitQuantity(BigDecimal waitQuantity) {
        this.waitQuantity = waitQuantity;
    }

    public BigDecimal getDoneQuantity() {
        return doneQuantity;
    }

    public void setDoneQuantity(BigDecimal doneQuantity) {
        this.doneQuantity = doneQuantity;
    }

    public BigDecimal getCancelQuantity() {
        return cancelQuantity;
    }

    public void setCancelQuantity(BigDecimal cancelQuantity) {
        this.cancelQuantity = cancelQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getDifferenceQuantity() {
        return differenceQuantity;
    }

    public void setDifferenceQuantity(BigDecimal differenceQuantity) {
        this.differenceQuantity = differenceQuantity;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }
}
