/**
 * @(#)CsInventoryWarningRespDto.java 1.0 2022/06/13 17:01
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jingran
 * @Description CsInventoryWarningRespDto
 * @Date: 2022/06/13 17:01
 * @since 1.0.0
 */
@ApiModel(value = "csInventoryWarningRespDto", description = "返回信息Dto")
public class CsInventoryWarningRespDto implements Serializable {
    /** ID */
    @ApiModelProperty(name = "id", value = "ID")
    private Long id;
    /** 商品sku编码 */
    @ApiModelProperty(name = "skuCode", value = "商品sku编码")
    private String skuCode;
    /** 商品sku名称 */
    @ApiModelProperty(name = "skuName", value = "商品sku名称")
    private String skuName;
    /** 批次 */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型")
    private String warehouseType;
    /** 预警库存 */
    @ApiModelProperty(name="warningInventory",value = "预警库存")
    private BigDecimal warningInventory;
    /** 可用库存 */
    @ApiModelProperty(name="available",value = "可用库存")
    private BigDecimal available;

    /** 更新时间 */
    @ApiModelProperty(name="updateTime",value = "更新时间")
    private Date updateTime;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public BigDecimal getWarningInventory() {
        return warningInventory;
    }

    public void setWarningInventory(BigDecimal warningInventory) {
        this.warningInventory = warningInventory;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
