/**
 * @(#)CsChannelWarehouseRespDto.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
* @Description CsChannelWarehouseRespDto
*
* @author jingran
* @Date: 2022/03/07 14:51
* @since 1.0.0
*/
@ApiModel(value = "csChannelWarehouseRespDto", description = "返回信息Dto")
public class CsChannelWarehouseRespDto extends BaseRespDto {

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库类型，待定 */
    @ApiModelProperty(name="warehouseType",value = "仓库类型，待定")
    private String warehouseType;
    /** 仓库状态 initial-初始,enable-有效,disable-无效 */
    @ApiModelProperty(name="warehouseStatus",value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 所属组织名称 */
    @ApiModelProperty(name="organizationName",value = "所属组织名称")
    private String organizationName;
    /** 组织code */
    @ApiModelProperty(name="organizationCode",value = "组织code")
    private String organizationCode;
    /** 关联的逻辑仓 */
    @ApiModelProperty(name="relWarehouseList",value = "关联的逻辑仓集合")
    private List<CsLogicWarehouseRespDto> relWarehouseList;
    /** 关联的逻辑仓 */
    @ApiModelProperty(name="relShopList",value = "关联的逻辑仓集合")
    private List<ShopBaseDto> relShopList;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public List<CsLogicWarehouseRespDto> getRelWarehouseList() {
        return relWarehouseList;
    }

    public void setRelWarehouseList(List<CsLogicWarehouseRespDto> relWarehouseList) {
        this.relWarehouseList = relWarehouseList;
    }

    public List<ShopBaseDto> getRelShopList() {
        return relShopList;
    }

    public void setRelShopList(List<ShopBaseDto> relShopList) {
        this.relShopList = relShopList;
    }
}
