package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 逻辑仓详情响应DTO
 *
 * @author jingran
 * @Description CsPhysicsWarehouseRespDto
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 **/
@ApiModel(value = "CsLogicWarehouseDetailRespDto", description = "逻辑仓详情响应DTO")
public class CsLogicWarehouseDetailRespDto extends BaseRespDto {
    /**
     * 仓库ID
     **/
    @ApiModelProperty(name = "id", value = "仓库ID")
    private Long id;
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 仓库类型
     **/
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;

    /**
     * 货权组织名称。货品归属权的组织
     **/
    @ApiModelProperty(name = "cargoEscheatageName", value = "货权组织名称。货品归属权的组织")
    private String cargoEscheatageName;

    /**
     * 货权组织ID。货品归属权的组织
     **/
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID。货品归属权的组织")
    private String cargoEscheatageId;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效 com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;

    /**
     * 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other
     */
    @ApiModelProperty(name = "warehouseQuality", value = "待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other ")
    private String warehouseQuality;

    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;

    /**
     * 所属物理仓仓库ID
     **/
    @ApiModelProperty(name = "subordinatePhysicsWarehouseId", value = "所属物理仓仓库ID")
    private Long subordinatePhysicsWarehouseId;

    /**
     * 所属物理仓仓库名称
     **/
    @ApiModelProperty(name = "subordinatePhysicsWarehouseName", value = "所属物理仓仓库名称")
    private String subordinatePhysicsWarehouseName;

    /**
     * 仓库属性
     **/
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 线上线下标识，线上-on_line   线下-off_line
     **/
    @ApiModelProperty(name = "warehouseOnlineFlag", value = "线上线下标识，线上-on_line   线下-off_line")
    private String warehouseOnlineFlag;

    /**
     * 创建人
     **/
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 是否默认退货仓：1.是，0.否
     */
    @ApiModelProperty(name = "isReturnWarehouse", value = "是否默认退货仓：1.是，0.否")
    private Integer isReturnWarehouse;

    /**
     * 转合格入库仓
     */
    @ApiModelProperty(name = "inQualifyWarehouse", value = "转合格入库仓")
    private String inQualifyWarehouse;
    @ApiModelProperty(name = "inQualifyWarehouseName", value = "转合格入库仓(名称)")
    private String inQualifyWarehouseName;

    /**
     * 近效期调入仓
     */
    @ApiModelProperty(name = "inNearExpireWarehouse", value = "近效期调入仓")
    private String inNearExpireWarehouse;
    @ApiModelProperty(name = "inNearExpireWarehouseName", value = "近效期调入仓(名称)")
    private String inNearExpireWarehouseName;
    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓(名称)")
    private String subordinateLogicWarehouseName;
    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;
    /**
     * 虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）
     */
    @ApiModelProperty(name = "isVirtual", value = "虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）")
    private Integer isVirtual;
    /**
     * 仓库对应系统
     */
    @ApiModelProperty(name = "warehouseCorrespondingSystem", value = "仓库对应系统")
    private String warehouseCorrespondingSystem;

    public String getWarehouseCorrespondingSystem() {
        return warehouseCorrespondingSystem;
    }

    public void setWarehouseCorrespondingSystem(String warehouseCorrespondingSystem) {
        this.warehouseCorrespondingSystem = warehouseCorrespondingSystem;
    }

    public Long getSubordinateLogicWarehouseId() {
        return subordinateLogicWarehouseId;
    }

    public void setSubordinateLogicWarehouseId(Long subordinateLogicWarehouseId) {
        this.subordinateLogicWarehouseId = subordinateLogicWarehouseId;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getSubordinateLogicWarehouseName() {
        return subordinateLogicWarehouseName;
    }

    public void setSubordinateLogicWarehouseName(String subordinateLogicWarehouseName) {
        this.subordinateLogicWarehouseName = subordinateLogicWarehouseName;
    }

    public Integer getIsReturnWarehouse() {
        return isReturnWarehouse;
    }

    public void setIsReturnWarehouse(Integer isReturnWarehouse) {
        this.isReturnWarehouse = isReturnWarehouse;
    }

    public String getInQualifyWarehouse() {
        return inQualifyWarehouse;
    }

    public void setInQualifyWarehouse(String inQualifyWarehouse) {
        this.inQualifyWarehouse = inQualifyWarehouse;
    }

    public String getInQualifyWarehouseName() {
        return inQualifyWarehouseName;
    }

    public void setInQualifyWarehouseName(String inQualifyWarehouseName) {
        this.inQualifyWarehouseName = inQualifyWarehouseName;
    }

    public String getInNearExpireWarehouse() {
        return inNearExpireWarehouse;
    }

    public void setInNearExpireWarehouse(String inNearExpireWarehouse) {
        this.inNearExpireWarehouse = inNearExpireWarehouse;
    }

    public String getInNearExpireWarehouseName() {
        return inNearExpireWarehouseName;
    }

    public void setInNearExpireWarehouseName(String inNearExpireWarehouseName) {
        this.inNearExpireWarehouseName = inNearExpireWarehouseName;
    }

    public Integer getIsVirtual() {
        return isVirtual;
    }

    public void setIsVirtual(Integer isVirtual) {
        this.isVirtual = isVirtual;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }

    @Override
    public String getCreatePerson() {
        return createPerson;
    }

    @Override
    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCargoEscheatageName() {
        return cargoEscheatageName;
    }

    public void setCargoEscheatageName(String cargoEscheatageName) {
        this.cargoEscheatageName = cargoEscheatageName;
    }

    public String getCargoEscheatageId() {
        return cargoEscheatageId;
    }

    public void setCargoEscheatageId(String cargoEscheatageId) {
        this.cargoEscheatageId = cargoEscheatageId;
    }

    public String getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(String warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public Long getSubordinatePhysicsWarehouseId() {
        return subordinatePhysicsWarehouseId;
    }

    public void setSubordinatePhysicsWarehouseId(Long subordinatePhysicsWarehouseId) {
        this.subordinatePhysicsWarehouseId = subordinatePhysicsWarehouseId;
    }

    public String getSubordinatePhysicsWarehouseName() {
        return subordinatePhysicsWarehouseName;
    }

    public void setSubordinatePhysicsWarehouseName(String subordinatePhysicsWarehouseName) {
        this.subordinatePhysicsWarehouseName = subordinatePhysicsWarehouseName;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getWarehouseOnlineFlag() {
        return warehouseOnlineFlag;
    }

    public void setWarehouseOnlineFlag(String warehouseOnlineFlag) {
        this.warehouseOnlineFlag = warehouseOnlineFlag;
    }
}
