/**
 * @(#)CsPhysicsWarehouseRespDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Date;

/**
 * 逻辑仓分页列表查询响应DTO
 *
 * @author jingran
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CsLogicWarehousePageRespDto", description = "逻辑仓分页列表查询响应DTO")
public class CsLogicWarehousePageRespDto extends BaseRespDto {

    /**
     * ID
     **/
    @ApiModelProperty(name = "id", value = "仓库ID")
    private Long id;
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;

    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;

    /**
     * 仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other ")
    private String warehouseQuality;

    /**
     * 所属物理仓仓库ID
     */
    @ApiModelProperty(name = "subordinatePhysicsWarehouseId", value = "所属物理仓仓库ID")
    private Long subordinatePhysicsWarehouseId;

    @ApiModelProperty(name = "subordinatePhysicsWarehouseCode", value = "所属物理仓仓库Code")
    private String subordinatePhysicsWarehouseCode;

    /**
     * 所属物理仓仓库名称
     */
    @ApiModelProperty(name = "subordinatePhysicsWarehouseName", value = "所属物理仓仓库名称")
    private String subordinatePhysicsWarehouseName;

    /**
     * 仓库属性
     * <p>
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehousePropertyEnum
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /**
     * eas仓库编码
     */
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 线上线下标识，线上-on_line   线下-off_line
     */
    @ApiModelProperty(name = "warehouseOnlineFlag", value = "线上线下标识，线上-on_line   线下-off_line")
    private String warehouseOnlineFlag;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 货权组织名称。货品归属权的组织
     */
    @ApiModelProperty(name = "cargoEscheatageName", value = "货权组织名称。货品归属权的组织")
    private String cargoEscheatageName;

    /**
     * 货权组织ID。货品归属权的组织
     */
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID。货品归属权的组织")
    private String cargoEscheatageId;

    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /***
     * 组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;
    /**
     * 是否默认退货仓：1.是，0.否
     */
    @ApiModelProperty(name = "isReturnWarehouse", value = "是否默认退货仓：1.是，0.否")
    private Integer isReturnWarehouse;

    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓,in_transit-在途仓")
    private String warehouseClassify;
    /**
     * 所属逻辑仓仓库ID
     */
    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    @ApiModelProperty(name = "subordinateLogicWarehouseCode", value = "所属逻辑仓仓库Code")
    private String subordinateLogicWarehouseCode;

    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓(名称)")
    private String subordinateLogicWarehouseName;

    @ApiModelProperty(name = "warehouseCorrespondingSystem", value = "仓库对应系统")
    private String warehouseCorrespondingSystem;

    @ApiModelProperty(name = "inNearExpireWarehouse", value = "近效期调入仓")
    private String inNearExpireWarehouse;

    /**
     * 虚拟逻辑仓是否开启：1.开启，0.不开启（默认不开启）
     */
    @ApiModelProperty(name = "isVirtual", value = "虚拟逻辑仓是否开启")
    private Integer isVirtual;

    /**
     * 转合格入库仓
     */
    @ApiModelProperty(name = "inQualifyWarehouse", value = "转合格入库仓")
    private String inQualifyWarehouse;


    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
}
