/**
 * @(#)CsPhysicsWarehouseRespDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 逻辑仓参数查询响应DTO，只查询逻辑仓信息，不查询其他信息
 *
 * @author jingran
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@ApiModel(value = "CsLogicWarehousePageRespDto", description = "逻辑仓参数查询响应DTO，只查询逻辑仓信息，不查询其他信息")
public class CsLogicWarehouseQueryParamRespDto extends BaseRespDto {

    /**
     * ID
     **/
    @ApiModelProperty(name = "id", value = "仓库ID")
    private Long id;
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    /**
     * 仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;

    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;

    /** 仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum
     *
     * */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质 待检-wait_inspection 不合格-un_qualified   合格-qualified    待处理-pending  其他-other ")
    private String warehouseQuality;

    /** 仓库属性
     *
     * com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehousePropertyEnum
     * */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /** eas仓库编码 */
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /** 线上线下标识，线上-on_line   线下-off_line */
    @ApiModelProperty(name = "warehouseOnlineFlag", value = "线上线下标识，线上-on_line   线下-off_line")
    private String warehouseOnlineFlag;

    /** 备注 */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /** 货权组织名称。货品归属权的组织 */
    @ApiModelProperty(name = "cargoEscheatageName", value = "货权组织名称。货品归属权的组织")
    private String cargoEscheatageName;

    /** 货权组织ID。货品归属权的组织 */
    @ApiModelProperty(name = "cargoEscheatageId", value = "货权组织ID。货品归属权的组织")
    private Long cargoEscheatageId;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(String warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEasWarehouseCode() {
        return easWarehouseCode;
    }

    public void setEasWarehouseCode(String easWarehouseCode) {
        this.easWarehouseCode = easWarehouseCode;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getWarehouseQuality() {
        return warehouseQuality;
    }

    public void setWarehouseQuality(String warehouseQuality) {
        this.warehouseQuality = warehouseQuality;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getWarehouseOnlineFlag() {
        return warehouseOnlineFlag;
    }

    public void setWarehouseOnlineFlag(String warehouseOnlineFlag) {
        this.warehouseOnlineFlag = warehouseOnlineFlag;
    }

    public String getCargoEscheatageName() {
        return cargoEscheatageName;
    }

    public void setCargoEscheatageName(String cargoEscheatageName) {
        this.cargoEscheatageName = cargoEscheatageName;
    }

    public Long getCargoEscheatageId() {
        return cargoEscheatageId;
    }

    public void setCargoEscheatageId(Long cargoEscheatageId) {
        this.cargoEscheatageId = cargoEscheatageId;
    }
}
