/**
 * @(#)CsPhysicsWarehouseRespDto.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 **/
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse;

//

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物理仓分页列表查询响应DTO
 *
 * @author jingran
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@Data
@ApiModel(value = "csPhysicsWarehouseRespDto", description = "物理仓分页列表查询响应DTO")
public class CsPhysicsWarehousePageRespDto extends BaseRespDto {
    /**
     * 仓库编码
     **/
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓库名称
     **/
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     * 仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓
     **/
    @ApiModelProperty(name = "warehouseType", value = "仓库类型 brand-品牌总仓,area-区域仓,agency-办事处仓.shop-门店仓,sale-特卖仓")
    private String warehouseType;
    /**
     * 仓库状态 initial-初始,enable-有效,disable-无效
     **/
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-有效,disable-无效")
    private String warehouseStatus;
    /**
     * 是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用
     **/
    @ApiModelProperty(name = "rdcFlag", value = "是否RDC 0-否 1-是，只有珠海不是rdc，待确认是否有业务使用")
    private String rdcFlag;
    /**
     * 备注
     **/
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * eas仓库编码
     **/
    @ApiModelProperty(name = "easWarehouseCode", value = "eas仓库编码")
    private String easWarehouseCode;

    /**
     * 国家编码
     **/
    @ApiModelProperty(name = "countryCode", value = "国家编码")
    private String countryCode;
    /**
     * 国家名称
     **/
    @ApiModelProperty(name = "country", value = "国家名称")
    private String country;
    /**
     * 省份编码
     **/
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;
    /**
     * 省份名称
     **/
    @ApiModelProperty(name = "province", value = "省份名称")
    private String province;
    /**
     * 城市编码
     **/
    @ApiModelProperty(name = "cityCode", value = "城市编码")
    private String cityCode;
    /**
     * 城市名称
     **/
    @ApiModelProperty(name = "city", value = "城市名称")
    private String city;
    /**
     * 区县编码
     **/
    @ApiModelProperty(name = "districtCode", value = "区县编码")
    private String districtCode;
    /**
     * 区县名称
     **/
    @ApiModelProperty(name = "district", value = "区县名称")
    private String district;
    /**
     * 详细地址
     **/
    @ApiModelProperty(name = "detailAddress", value = "详细地址")
    private String detailAddress;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /***
     * 组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    @ApiModelProperty(name = "isLogistics", value = "是否物流仓")
    private Integer isLogistics;

    @ApiModelProperty(name = "logisticsFlag", value = "物流标记")
    private String logisticsFlag;
}
